 /************************************************************************/
 /*                                                                      */
 /*                Centre for Speech Technology Research                 */
 /*                     University of Edinburgh, UK                      */
 /*                       Copyright (c) 1996,1997                        */
 /*                        All Rights Reserved.                          */
 /*                                                                      */
 /*  Permission to use, copy, modify, distribute this software and its   */
 /*  documentation for research, educational and individual use only, is */
 /*  hereby granted without fee, subject to the following conditions:    */
 /*   1. The code must retain the above copyright notice, this list of   */
 /*      conditions and the following disclaimer.                        */
 /*   2. Any modifications must be clearly marked as such.               */
 /*   3. Original authors' names are not deleted.                        */
 /*  This software may not be used for commercial purposes without       */
 /*  specific prior written permission from the authors.                 */
 /*                                                                      */
 /*  THE UNIVERSITY OF EDINBURGH AND THE CONTRIBUTORS TO THIS WORK       */
 /*  DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING     */
 /*  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT  */
 /*  SHALL THE UNIVERSITY OF EDINBURGH NOR THE CONTRIBUTORS BE LIABLE    */
 /*  FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES   */
 /*  WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN  */
 /*  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,         */
 /*  ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF      */
 /*  THIS SOFTWARE.                                                      */
 /*                                                                      */
 /*************************************************************************/

class SchemeModuleDescription;

#ifndef __SCHEMEMODULEDESCRIPTIONT_H__
#define __SCHEMEMODULEDESCRIPTIONT_H__

#include "EST.h"
#include "SubtypedObject.h"
#include "ModuleDescription.h"

/** Wrapper around the ModuleDescription record to allow them to be
  * seen from scheme.
  * @see ModuleDescription
  * @author Richard Caley <rjc@cstr,ed,ac,uk>
  * @version $Id: SchemeModuleDescription.h,v 1.1 1998/08/12 09:35:52 awb Exp $
  */

class SchemeModuleDescription : public SchemeObject {

public:

private:
  /// Pointer to actual record.
  const struct ModuleDescription *p_description;
  /// Was the record created or was it a static description passed in.
  bool p_allocated;

public:

  /// Create from an existing description.
  SchemeModuleDescription(const ModuleDescription *description=NULL, 
			  bool allocated=FALSE);

  /// Virtual desctructor.
  virtual ~SchemeModuleDescription(void); 

  /// Name of the type.
  virtual EST_String type_name(void) const;

  /**@name Properties */
  //@{
  /// List of all the available properties.
  virtual void property_names(EST_TList<EST_String> &list) const;
  /// Set a property.
  virtual int set_property(EST_String property, ValueType value);
  /// Get property value.
  virtual ValueType property(EST_String property) const;
  //@}

  /// Print out the description.
  void print_description(FILE *stream) const;

#if defined(INCLUDE_LISP)

  /**@name Scheme interface
    * These are the functions which are imported into Scheme. 
    */
  //@{

protected:
  /// The type tag used in Scheme cells copntaining this type of object.
  static int s_lisp_type;

public:
  /// Create a description from a list structure.
  static LISP lisp_create(LISP list_form);
  /// Print out the description.
  static LISP lisp_print_description(LISP ldescription, LISP lstream);
  /// Initialisation function.
  static void lisp_declare(void);
  //@}
#endif 

};

#endif
 //@}
