 /*************************************************************************/
 /*                                                                       */
 /*                Centre for Speech Technology Research                  */
 /*                     University of Edinburgh, UK                       */
 /*                      Copyright (c) 1995,1996                          */
 /*                        All Rights Reserved.                           */
 /*                                                                       */
 /*  Permission to use, copy, modify, distribute this software and its    */
 /*  documentation for research, educational and individual use only, is  */
 /*  hereby granted without fee, subject to the following conditions:     */
 /*   1. The code must retain the above copyright notice, this list of    */
 /*      conditions and the following disclaimer.                         */
 /*   2. Any modifications must be clearly marked as such.                */
 /*   3. Original authors' names are not deleted.                         */
 /*  This software may not be used for commercial purposes without        */
 /*  specific prior written permission from the authors.                  */
 /*                                                                       */
 /*  THE UNIVERSITY OF EDINBURGH AND THE CONTRIBUTORS TO THIS WORK        */
 /*  DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING      */
 /*  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT   */
 /*  SHALL THE UNIVERSITY OF EDINBURGH NOR THE CONTRIBUTORS BE LIABLE     */
 /*  FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES    */
 /*  WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN   */
 /*  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,          */
 /*  ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF       */
 /*  THIS SOFTWARE.                                                       */
 /*                                                                       */
 /*************************************************************************/
 /*                                                                       */
 /*                 Author: Richard Caley (rjc@cstr.ed.ac.uk)             */
 /*                   Date: Fri Oct 10 1997                               */
 /* --------------------------------------------------------------------  */
 /* A subclass of TVector which copies using memcopy. This isn't          */
 /* suitable for Matrixes of class objects which have to be copied        */
 /* useing a constructor or specialised assignment operator.              */
 /*                                                                       */
 /*************************************************************************/

#include "EST_TSimpleVector.h"
#include <fstream.h>
#include "EST_cutils.h"

template<class T> void EST_TSimpleVector<T>::copy(const EST_TSimpleVector<T> &a)
{
  if (p_column_step==1 && a.p_column_step==1)
    {
    resize(a.n(), FALSE);
    memcpy((void *)(p_memory+p_offset), (const void *)(a.p_memory+a.p_offset), n() * sizeof(T));
    }
else
  ((EST_TVector<T> *)this)->copy(a);
}

template<class T> EST_TSimpleVector<T>::EST_TSimpleVector(const EST_TSimpleVector<T> &in)
{
    default_vals();    
    copy(in);
}

// should copy from and delete old version first
template<class T> void EST_TSimpleVector<T>::resize(int newn, int set)
{
  int oldn = n();
  T *old_vals =NULL;

  just_resize(newn, &old_vals);

  if (set && old_vals)
    {
      int copy_c = 0;
      if (p_memory != NULL)
	{
	  copy_c = Lof(n(), oldn);
	  memcpy((void *)p_memory, (const void *)old_vals,  copy_c* sizeof(T));
	}
      
      for (int i=copy_c; i < n(); ++i)
	p_memory[i] = *def_val;
    }
  
  if (old_vals != NULL && old_vals != p_memory && !p_sub_matrix)
    delete [] old_vals;

}

template<class T>
void EST_TSimpleVector<T>::copy_section(T* dest, int offset, int num) const
{
  if (num<0)
    num = num_columns()-offset;

  if (!EST_vector_bounds_check(num+offset-1, num_columns(), FALSE))
    return;

  if (!p_sub_matrix && p_column_step==1)
    memcpy((void *)dest, (const void *)(p_memory+offset), num*sizeof(T));
  else
    for(int i=0; i<num; i++)
      dest[i] = a_no_check(offset+i);
}

template<class T>
void EST_TSimpleVector<T>::set_section(const T* src, int offset, int num)
{
  if (num<0)
    num = num_columns()-offset;

  if (!EST_vector_bounds_check(num+offset-1, num_columns(), FALSE))
    return;
  
  if (!p_sub_matrix && p_column_step==1)
    memcpy((void *)(p_memory+offset), (void *)src, num*sizeof(T));
  else
    for(int i=0; i<num; i++)
      a_no_check(offset+i) = src[i];
}

template<class T> EST_TSimpleVector<T> &EST_TSimpleVector<T>::operator=(const EST_TSimpleVector<T> &in)
{
    copy(in);
    return *this;
}

