 ###########################################################################
 ##                                                                       ##
 ##                Centre for Speech Technology Research                  ##
 ##                     University of Edinburgh, UK                       ##
 ##                         Copyright (c) 1996                            ##
 ##                        All Rights Reserved.                           ##
 ##                                                                       ##
 ##  Permission to use, copy, modify, distribute this software and its    ##
 ##  documentation for research, educational and individual use only, is  ##
 ##  hereby granted without fee, subject to the following conditions:     ##
 ##   1. The code must retain the above copyright notice, this list of    ##
 ##      conditions and the following disclaimer.                         ##
 ##   2. Any modifications must be clearly marked as such.                ##
 ##   3. Original authors' names are not deleted.                         ##
 ##  This software may not be used for commercial purposes without        ##
 ##  specific prior written permission from the authors.                  ##
 ##                                                                       ##
 ##  THE UNIVERSITY OF EDINBURGH AND THE CONTRIBUTORS TO THIS WORK        ##
 ##  DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING      ##
 ##  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT   ##
 ##  SHALL THE UNIVERSITY OF EDINBURGH NOR THE CONTRIBUTORS BE LIABLE     ##
 ##  FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES    ##
 ##  WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN   ##
 ##  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,          ##
 ##  ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF       ##
 ##  THIS SOFTWARE.                                                       ##
 ##                                                                       ##
 ###########################################################################
 ##                                                                       ##
 ##                 Author: Richard Caley (rjc@cstr.ed.ac.uk)             ##
 ##                   Date: Fri Feb 27th 1998                             ##
 ## --------------------------------------------------------------------  ##
 ## Rules for java.                                                       ##
 ##                                                                       ##
 ###########################################################################

JAVA_TOP     = $(PROJECT_JAVA_ROOT)
JAVA_PACKAGE = $(subst /,.,$(subst java/,,$(DIRNAME)))

JAVA_CLASSES_CLASS = $(JAVA_CLASSES:%=%.class)
JAVA_CLASSES_JAVA = $(JAVA_CLASSES:%=%.java)

ifdef JAVA_NATIVE_CLASSES
    JAVA_CLASSES_O = $(JAVA_NATIVE_CLASSES:%=%.o)

jni_%.h : %.class
	@$(RM) -f jni_$*.h
	$(JAVAH) -classpath '$(PROJECT_JAVA_ROOT):$(JAVA_CLASSPATH)' -o jni_$*.h $(JAVA_PACKAGE).$*

INCLUDES += $(JAVA_INCLUDES)

.java : $(JAVA_NATIVE_CLASSES:%=jni_%.h) $(JAVA_CLASSES_CLASS) 

else

.java :  $(JAVA_CLASSES_CLASS)

endif

.javalib:  FORCE
	@if [ -f $(JAVA_TOP)/.java_updates ] ;\
		then \
		$(MAKE) .java_class_list ;\
		echo Create Java Archive ;\
		$(JAR) $(JAVA_CLASS_LIBRARY) `cat .java_class_list` ;\
		$(RM) $(JAVA_TOP)/.java_updates ;\
	fi


.java_class_list: FORCE
	@echo Finding classes
	@find . -follow \( -name RCS -prune \) -o -name '*.class' -print | sed -e '/^\.\//s///' > .java_class_list

ifndef JAVAC_COMMAND
    JAVAC_COMMAND = $(JAVAC) $(JAVAFLAGS) -classpath '$(PROJECT_JAVA_ROOT):$(JAVA_CLASSPATH)'
endif

%.class : %.java
	$(strip $(JAVAC_COMMAND)  $*.java)
	@$(ECHO_N) $*.class >> $(JAVA_TOP)/.java_updates


