 /************************************************************************/
 /*                                                                      */
 /*                Centre for Speech Technology Research                 */
 /*                     University of Edinburgh, UK                      */
 /*                       Copyright (c) 1996,1997                        */
 /*                        All Rights Reserved.                          */
 /*                                                                      */
 /*  Permission to use, copy, modify, distribute this software and its   */
 /*  documentation for research, educational and individual use only, is */
 /*  hereby granted without fee, subject to the following conditions:    */
 /*   1. The code must retain the above copyright notice, this list of   */
 /*      conditions and the following disclaimer.                        */
 /*   2. Any modifications must be clearly marked as such.               */
 /*   3. Original authors' names are not deleted.                        */
 /*  This software may not be used for commercial purposes without       */
 /*  specific prior written permission from the authors.                 */
 /*                                                                      */
 /*  THE UNIVERSITY OF EDINBURGH AND THE CONTRIBUTORS TO THIS WORK       */
 /*  DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING     */
 /*  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT  */
 /*  SHALL THE UNIVERSITY OF EDINBURGH NOR THE CONTRIBUTORS BE LIABLE    */
 /*  FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES   */
 /*  WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN  */
 /*  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,         */
 /*  ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF      */
 /*  THIS SOFTWARE.                                                      */
 /*                                                                      */
 /*************************************************************************/
 /*                                                                       */
 /*                 Author: Richard Caley (rjc@cstr.ed.ac.uk)             */
 /*                   Date: Thu Aug 14 1997                               */
 /* --------------------------------------------------------------------  */
 /* Fatal error calls.                                                    */
 /*                                                                       */
 /*************************************************************************/

#ifndef __EST_ERROR_H__
#define __EST_ERROR_H__

#include <stdarg.h>
#include <stdio.h>
#include <setjmp.h>
#include "EST_unix.h"

#ifdef __cplusplus
extern "C" {
#endif

#define MAX_ERROR_MESSAGE_LENGTH 1024
extern const char *EST_error_where;
extern char *EST_error_message;

extern void (*EST_error_func)(const char *format, ...);
extern void (*EST_sys_error_func)(const char *format, ...);
extern void (*EST_warning_func)(const char *format, ...);

extern FILE *EST_error_stream;
extern FILE *EST_warning_stream;

extern jmp_buf *est_errjmp;
extern long errjmp_ok;

extern void EST_errors_default();
extern void EST_errors_quiet();

#define __S_(X) #X
#define __s_(X) __S_(X)

#define EST_error (EST_error_where = __FILE__ ", line " __s_(__LINE__)),\
			(*EST_error_func)
#define EST_warning (EST_error_where = __FILE__ ", line " __s_(__LINE__)),\
			(*EST_warning_func)
#define EST_sys_error (EST_error_where = __FILE__ ", line " __s_(__LINE__)),\
			  (*EST_sys_error_func)

#define est_error_throw() (est_errjmp ? longjmp(*est_errjmp,1) : (void)exit(-1))
#define est_error() (est_errjmp ? longjmp(*est_errjmp,1) : (void)exit(-1))

#define CATCH_ERRORS() \
	jmp_buf *old_errjmp = est_errjmp; \
	int old_errjmp_ok = errjmp_ok; \
	errjmp_ok =1; \
        est_errjmp = walloc(jmp_buf,1); \
	int jmp_val = setjmp(*est_errjmp); \
	if (jmp_val) { wfree(est_errjmp); est_errjmp = old_errjmp;  errjmp_ok = old_errjmp_ok; nointerrupt = 0;} \
        if (jmp_val)
#define END_CATCH_ERRORS() \
	do { \
	   wfree(est_errjmp); \
           est_errjmp = old_errjmp; \
	   errjmp_ok = old_errjmp_ok; \
	   } while (0)

#ifdef __cplusplus
	   }
#endif

#endif
