/*************************************************************************/
/*                                                                       */
/*                Centre for Speech Technology Research                  */
/*                     University of Edinburgh, UK                       */
/*                     Copyright (c) 1994,1995,1996                      */
/*                        All Rights Reserved.                           */
/*                                                                       */
/*  Permission to use, copy, modify, distribute this software and its    */
/*  documentation for research, educational and individual use only, is  */
/*  hereby granted without fee, subject to the following conditions:     */
/*   1. The code must retain the above copyright notice, this list of    */
/*      conditions and the following disclaimer.                         */
/*   2. Any modifications must be clearly marked as such.                */
/*   3. Original authors' names are not deleted.                         */
/*  This software may not be used for commercial purposes without        */
/*  specific prior written permission from the authors.                  */
/*                                                                       */
/*  THE UNIVERSITY OF EDINBURGH AND THE CONTRIBUTORS TO THIS WORK        */
/*  DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING      */
/*  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT   */
/*  SHALL THE UNIVERSITY OF EDINBURGH NOR THE CONTRIBUTORS BE LIABLE     */
/*  FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES    */
/*  WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN   */
/*  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,          */
/*  ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF       */
/*  THIS SOFTWARE.                                                       */
/*                                                                       */
/*************************************************************************/
/*                    Author :  Paul Taylor                              */
/*                    Date   :  April 1994                               */
/*-----------------------------------------------------------------------*/
/*        Utility Function header file  for C and C++                    */
/*                                                                       */
/*=======================================================================*/

#ifndef __RW_STATUS_H__
#define __RW_STATUS_H__


#ifdef __cplusplus
extern "C" {
#endif

#include <stdio.h>
#include <errno.h>

  /*
   * make_status_int builds the status as an integer
   * make_X_status casts it to the required type.
   */

#define make_status_int(STATE, REASON, ERRNO) \
  (  ((((unsigned int)(STATE))  & 0xff)   <<24) \
   | ((((unsigned int)(REASON)) & 0xff)   <<16) \
   | ((((unsigned int)(ERRNO))  & 0xffff) <<00) \
     )

#define make_read_status(STATE, REASON, ERRNO)\
    ((EST_read_status)(make_status_int(STATE, REASON, ERRNO)))

#define make_write_status(STATE, REASON, ERRNO) \
    ((EST_write_status)(make_status_int(REASON, STATE, ERRNO)))

    /*
     * Extract the bits.
     */

#define get_rw_state(STATUS)	\
    ((EST_rw_state)((((unsigned int)(STATUS)) >> 24) & 0xff))
#define get_rw_reason(STATUS)	\
    ((EST_rw_reason)((((unsigned int)(STATUS)) >> 16) & 0xff))
#define get_rw_errno(STATUS)	\
    ((int)((((unsigned int)(STATUS)) >> 0) & 0xff))


  /*
   * Why we failed.
   */

enum EST_rw_reason {
  rwr_none=0,
  rwr_format=1,
  rwr_unknown=0xff
};

/** State of rw */
enum EST_rw_state {
    /// ok
  rws_ok=0,
    /// partial
  rws_partial=1,
    /// permission
  rws_permission=2,
    /// failed
  rws_failed=0xff
};


/** Possible outcomes of a file reading operation. More stuff*/
enum EST_read_status {
    /// The file was read in successfully
  read_ok		= make_status_int(rws_ok,	rwr_none,	0),
    /// The file exists but is not in the format specified
  read_format_error	= make_status_int(rws_failed,	rwr_format,	0),
    /// An error occurred while reading
  read_error		= make_status_int(rws_failed,	rwr_unknown,	0)
};


/** Possible outcomes of a file writing operation */
enum EST_write_status {
    /// The file was written successfully
  write_ok		= make_status_int(rws_ok,	rwr_none,	0),
    /// The file was not written successfully
  write_fail		= make_status_int(rws_failed,	rwr_unknown,	0),
    /// The file was not written successfully
  write_error		= make_status_int(rws_failed,	rwr_unknown,	0)
};



#ifdef __cplusplus
}
#endif

/*
 * Temporary redefinitions of the old values.
 */

#define format_ok read_ok
#define wrong_format read_format_error
#define misc_read_error read_error
#define misc_write_error write_error

#endif /*__RW_STATUS_H__ */
