
 /************************************************************************/
 /*                                                                      */
 /*                Centre for Speech Technology Research                 */
 /*                     University of Edinburgh, UK                      */
 /*                       Copyright (c) 1996,1997                        */
 /*                        All Rights Reserved.                          */
 /*                                                                      */
 /*  Permission to use, copy, modify, distribute this software and its   */
 /*  documentation for research, educational and individual use only, is */
 /*  hereby granted without fee, subject to the following conditions:    */
 /*   1. The code must retain the above copyright notice, this list of   */
 /*      conditions and the following disclaimer.                        */
 /*   2. Any modifications must be clearly marked as such.               */
 /*   3. Original authors' names are not deleted.                        */
 /*  This software may not be used for commercial purposes without       */
 /*  specific prior written permission from the authors.                 */
 /*                                                                      */
 /*  THE UNIVERSITY OF EDINBURGH AND THE CONTRIBUTORS TO THIS WORK       */
 /*  DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING     */
 /*  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT  */
 /*  SHALL THE UNIVERSITY OF EDINBURGH NOR THE CONTRIBUTORS BE LIABLE    */
 /*  FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES   */
 /*  WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN  */
 /*  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,         */
 /*  ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF      */
 /*  THIS SOFTWARE.                                                      */
 /*                                                                      */
 /*************************************************************************/


#ifndef __EST_THASH_I_H__
#define __EST_THASH_I_H__

/** Instantiate rules for hash template.
  * 
  * @author Richard Caley <rjc@cstr.ed.ac.uk>
  * @version $Id: EST_THashI.h,v 1.1 1998/08/12 09:29:25 awb Exp $
  */

// Instantiation Macros

#define Instantiate_THash_T(KEY, VAL, TAG) \
        template class EST_Hash_Pair< KEY, VAL >; \
        template class EST_THash< KEY, VAL >;

#define Instantiate_THash(KEY, VAL) Instantiate_THash_T(KEY, VAL, KEY ## VAL) 

#define Declare_THash_T(KEY, VAL, TAG) \
	VAL EST_THash< KEY, VAL >::Dummy_Value; \
	EST_THash< KEY, VAL > TAG ## _hash_dummy(0);

#define Declare_THash_Base_T(KEY, VAL, DEFAULT,ERROR,TAG) \
	VAL EST_THash<KEY, VAL>::Dummy_Value=DEFAULT;

#define Declare_THash_Class_T(KEY, VAL, DEFAULT,ERROR,TAG) \
	VAL EST_THash<KEY, VAL>::Dummy_Value(DEFAULT);

#define Declare_THash(KEY, VAL) Declare_THash_T(KEY, VAL, KEY ## VAL)

#define Declare_THash_Base(KEY, VAL, DEFAULT,ERROR)  Declare_THash_Base_T(KEY, VAL, DEFAULT,ERROR, KEY ## VAL)
#define Declare_THash_Class(KEY, VAL, DEFAULT,ERROR) Declare_THash_Class_T(KEY, VAL, DEFAULT,ERROR, KEY ## VAL)

#endif

