/*************************************************************************/
/*                                                                       */
/*                Centre for Speech Technology Research                  */
/*                     University of Edinburgh, UK                       */
/*                     Copyright (c) 1995,1996                           */
/*                        All Rights Reserved.                           */
/*                                                                       */
/*  Permission to use, copy, modify, distribute this software and its    */
/*  documentation for research, educational and individual use only, is  */
/*  hereby granted without fee, subject to the following conditions:     */
/*   1. The code must retain the above copyright notice, this list of    */
/*      conditions and the following disclaimer.                         */
/*   2. Any modifications must be clearly marked as such.                */
/*   3. Original authors' names are not deleted.                         */
/*  This software may not be used for commercial purposes without        */
/*  specific prior written permission from the authors.                  */
/*                                                                       */
/*  THE UNIVERSITY OF EDINBURGH AND THE CONTRIBUTORS TO THIS WORK        */
/*  DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING      */
/*  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT   */
/*  SHALL THE UNIVERSITY OF EDINBURGH NOR THE CONTRIBUTORS BE LIABLE     */
/*  FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES    */
/*  WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN   */
/*  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,          */
/*  ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF       */
/*  THIS SOFTWARE.                                                       */
/*                                                                       */
/*************************************************************************/

/**@name EST_fft.h
  * Edinburgh Speech Tools signal processing functions.
  * <p>
  * @author Paul Taylor<pault@cstr.ed.ac.uk>
  * @version $Id: EST_fft.h,v 1.1 1998/08/12 09:29:25 awb Exp $
  */
//@{   

#ifndef __EST_FFT_H__
#define __EST_FFT_H__

#include "EST_Wave.h"
#include "EST_Track.h"
#include "EST_FMatrix.h"

/**@name FFT functions */
//@{
/// Basic in-place FFT
int slowFFT(EST_FVector &real, EST_FVector &imag);

/// Alternate name for slowFFT
inline int FFT(EST_FVector &real, EST_FVector &imag){
    return slowFFT(real, imag);
}

/// Basic inverse in-place FFT
int slowIFFT(EST_FVector &real, EST_FVector &imag);

/// Alternate name for slowIFFT
inline int IFFT(EST_FVector &real, EST_FVector &imag){
    return slowIFFT(real, imag);
}
/// power spectrun

int power_spectrum(EST_FVector &real, EST_FVector &imag);

/// Tony Robinsons fast version
int fastFFT(EST_FVector &invec);
/// Auxiliary for fastFFT
int fastlog2(int);

//@}

#endif // __EST_FFT_H__
//@}
