
#include <stdio.h>
#include "jni_Item.h"
#include "ling_class/EST_Item.h"
#include "ling_class/EST_Stream.h"
#include "ling_class/EST_Stream_Item.h"

static jobject item_class;
static jfieldID handle_field;

static inline short abs(short s) { return s>0?s:-s; }

JNIEXPORT jboolean JNICALL
Java_cstr_est_cpp_Item_initialise_1cpp (JNIEnv *env, jclass myclass)
{
  item_class = env->NewGlobalRef(myclass);
  handle_field = env->GetFieldID(myclass, "cpp_handle", "J");

  if (!handle_field)
    {
    printf("can't find cpp_handle!\n");
    return 0;
    }

  return 1;
}

JNIEXPORT jboolean JNICALL 
Java_cstr_est_cpp_Item_finalise_1cpp (JNIEnv *env, jclass myclass)
{
  (void)env;
  (void)myclass;
  return 1;
}

JNIEXPORT jboolean JNICALL 
Java_cstr_est_cpp_Item_create_1cpp_1item(JNIEnv *env, 
						 jobject self,
						 jlong handle
						 )
{
  EST_Item *item =(handle == 0L
			   ? (new EST_Item)
			   : (EST_Item *)handle
			   );

  // printf("create item %x\n", item);

  env->SetLongField(self, handle_field, (jlong)item);

  return 1;
}

JNIEXPORT jboolean JNICALL 
Java_cstr_est_cpp_Item_destroy_1cpp_1item (JNIEnv *env, jobject self)
{
  EST_Item *item = (EST_Item *) env->GetLongField(self, handle_field);

  // printf("destroy item  %x\n", item);

  delete item;
  return 1;
}

JNIEXPORT jstring JNICALL 
Java_cstr_est_cpp_Item_cpp_1name(JNIEnv *env, jobject self)
{
  EST_Item *item = (EST_Item *) env->GetLongField(self, handle_field);

  EST_String name = item->name();

  return  env->NewStringUTF(name);
}

JNIEXPORT jstring JNICALL 
Java_cstr_est_cpp_Item_cpp_1getS(JNIEnv *env, jobject self, jstring jname)
{
  EST_Item *item = (EST_Item *) env->GetLongField(self, handle_field);
  const char *name = env->GetStringUTFChars(jname, 0);
  
  EST_String val = item->fS(name);

  env->ReleaseStringUTFChars(jname, name);
  
  return  env->NewStringUTF(val);
}

JNIEXPORT jfloat JNICALL 
Java_cstr_est_cpp_Item_cpp_1getF(JNIEnv *env, jobject self, jstring jname)
{
  EST_Item *item = (EST_Item *) env->GetLongField(self, handle_field);
  const char *name = env->GetStringUTFChars(jname, 0);
  
  float val = item->fF(name);

  env->ReleaseStringUTFChars(jname, name);
  
  return  val;
}

JNIEXPORT jfloat JNICALL 
Java_cstr_est_cpp_Item_cpp_1getStartTime(JNIEnv *env, jobject self)
{
  EST_Item *item = (EST_Item *) env->GetLongField(self, handle_field);

  return  item?item->start():0.0;
}

JNIEXPORT jfloat JNICALL 
Java_cstr_est_cpp_Item_cpp_1getMidTime(JNIEnv *env, jobject self)
{
  EST_Item *item = (EST_Item *) env->GetLongField(self, handle_field);

  return  item?item->mid():0.0;
}

JNIEXPORT jfloat JNICALL 
Java_cstr_est_cpp_Item_cpp_1getEndTime(JNIEnv *env, jobject self)
{
  EST_Item *item = (EST_Item *) env->GetLongField(self, handle_field);

  return  item?item->end():0.0;
}

JNIEXPORT jlong JNICALL 
Java_cstr_est_cpp_Item_cpp_1getContent(JNIEnv *env, jobject self)
{
  EST_Item *item = (EST_Item *) env->GetLongField(self, handle_field);
  EST_Item_Content *itemc = item->contents();

  return  (long)itemc;
}

JNIEXPORT jstring JNICALL 
Java_cstr_est_cpp_Item_cpp_1type(JNIEnv *env, jobject self)
{
  EST_Item *item = (EST_Item *) env->GetLongField(self, handle_field);

  const char *type;

  if (item->parent() || item->daughters())
    type = "tree";
  else
    type = "linear";

  return  env->NewStringUTF(type);
}

JNIEXPORT jlong JNICALL 
Java_cstr_est_cpp_Item_cpp_1next(JNIEnv *env, jobject self)
{
  EST_Item *item = (EST_Item *) env->GetLongField(self, handle_field);

  return (long)item->next();
}

JNIEXPORT jlong JNICALL 
Java_cstr_est_cpp_Item_cpp_1prev(JNIEnv *env, jobject self)
{
  EST_Item *item = (EST_Item *) env->GetLongField(self, handle_field);

  return (long)item->prev();
}

JNIEXPORT jlong JNICALL 
Java_cstr_est_cpp_Item_cpp_1up(JNIEnv *env, jobject self)
{
  EST_Item *item = (EST_Item *) env->GetLongField(self, handle_field);

  return (long)item->up();
}

JNIEXPORT jlong JNICALL 
Java_cstr_est_cpp_Item_cpp_1down(JNIEnv *env, jobject self)
{
  EST_Item *item = (EST_Item *) env->GetLongField(self, handle_field);

  return (long)item->down();
}

