/*
 * Decompiled with CFR 0.152.
 */
package netscape.softupdate;

import java.util.Enumeration;
import netscape.security.Principal;
import netscape.security.PrivilegeManager;
import netscape.softupdate.RegKeyEnumerator;
import netscape.softupdate.RegistryErrors;
import netscape.softupdate.RegistryException;
import netscape.softupdate.RegistryNode;

public final class Registry
implements RegistryErrors {
    protected static final int ROOTKEY_USERS = 1;
    protected static final int ROOTKEY_COMMON = 2;
    protected static final int ROOTKEY_CURRENT_USER = 3;
    protected static final int ROOTKEY_PRIVATE = 4;
    protected static final int ROOTKEY = 32;
    protected static final int ROOTKEY_VERSIONS = 33;
    protected static final int PRIVATE_KEY_COMMON = -2;
    protected static final int PRIVATE_KEY_USER = -3;
    protected static final int ENUM_NORMAL = 0;
    protected static final int ENUM_DESCEND = 1;
    public static final int TYPE_STRING = 17;
    public static final int TYPE_INT_ARRAY = 18;
    public static final int TYPE_BYTES = 19;
    private static final String PRIVATE = "PrivateRegistryAccess";
    private static final String STANDARD = "StandardRegistryAccess";
    private static final String ADMIN = "AdministratorRegistryAccess";
    private int hReg;
    private String regName;
    private String username;

    public Registry() throws RegistryException {
        this("");
    }

    private Registry(String string) throws RegistryException {
        this.regName = string;
        PrivilegeManager.checkPrivilegeEnabled(PRIVATE);
        int n = this.nOpen();
        if (n != 0) {
            throw new RegistryException(n);
        }
    }

    public RegistryNode addNode(RegistryNode registryNode, String string) throws RegistryException {
        int n;
        String string2;
        if (registryNode == null) {
            string2 = ADMIN;
            n = 32;
        } else {
            string2 = registryNode.getTarget();
            n = registryNode.getKey();
        }
        PrivilegeManager.checkPrivilegeEnabled(string2);
        int n2 = this.nAddKey(n, string);
        if (n2 != 0) {
            throw new RegistryException(n2);
        }
        return this.nGetKey(n, string, string2);
    }

    public void deleteNode(RegistryNode registryNode, String string) throws RegistryException {
        int n;
        String string2;
        if (registryNode == null) {
            string2 = ADMIN;
            n = 32;
        } else {
            string2 = registryNode.getTarget();
            n = registryNode.getKey();
        }
        PrivilegeManager.checkPrivilegeEnabled(string2);
        int n2 = this.nDeleteKey(n, string);
        if (n2 != 0) {
            throw new RegistryException(n2);
        }
    }

    public RegistryNode getNode(RegistryNode registryNode, String string) throws RegistryException {
        int n;
        String string2;
        if (registryNode == null) {
            string2 = ADMIN;
            n = 32;
        } else {
            string2 = registryNode.getTarget();
            n = registryNode.getKey();
        }
        PrivilegeManager.checkPrivilegeEnabled(string2);
        return this.nGetKey(n, string, string2);
    }

    public Enumeration children(RegistryNode registryNode, String string) throws RegistryException {
        RegistryNode registryNode2 = this.getNode(registryNode, string);
        return new RegKeyEnumerator(this, registryNode2.getKey(), 0, registryNode2.getTarget());
    }

    public Enumeration subtree(RegistryNode registryNode, String string) throws RegistryException {
        RegistryNode registryNode2 = this.getNode(registryNode, string);
        return new RegKeyEnumerator(this, registryNode2.getKey(), 1, registryNode2.getTarget());
    }

    public RegistryNode getSharedNode() throws RegistryException {
        PrivilegeManager.checkPrivilegeEnabled(STANDARD);
        return this.nGetKey(2, "", STANDARD);
    }

    public RegistryNode getSharedUserNode() throws RegistryException {
        PrivilegeManager.checkPrivilegeEnabled(STANDARD);
        return this.nGetKey(3, "", STANDARD);
    }

    public RegistryNode getPrivateNode() throws RegistryException {
        PrivilegeManager.checkPrivilegeEnabled(PRIVATE);
        Principal[] principalArray = PrivilegeManager.getPrivilegeManager().getClassPrincipalsFromStack(1);
        if (principalArray == null) {
            System.out.println("Registry called without principals");
            throw new NullPointerException("Registry called without principals");
        }
        String string = "/" + principalArray[0].getFingerPrint() + "/Common";
        int n = this.nAddKey(4, string);
        if (n != 0) {
            throw new RegistryException(n);
        }
        return this.nGetKey(4, string, PRIVATE);
    }

    public RegistryNode getPrivateUserNode() throws RegistryException {
        PrivilegeManager.checkPrivilegeEnabled(PRIVATE);
        Principal[] principalArray = PrivilegeManager.getPrivilegeManager().getClassPrincipalsFromStack(1);
        if (principalArray == null) {
            System.out.println("Registry called without principals");
            throw new NullPointerException("Registry called without principals");
        }
        String string = "/" + principalArray[0].getFingerPrint() + "/Users/" + this.userName();
        int n = this.nAddKey(4, string);
        if (n != 0) {
            throw new RegistryException(n);
        }
        return this.nGetKey(4, string, PRIVATE);
    }

    protected void finalize() throws Throwable {
        if (this.hReg != 0) {
            this.nClose();
        }
    }

    private String userName() {
        if (this.username == null) {
            this.username = this.nUserName();
        }
        return this.username;
    }

    private native int nOpen();

    private native int nClose();

    private native int nAddKey(int var1, String var2);

    private native int nDeleteKey(int var1, String var2);

    private native RegistryNode nGetKey(int var1, String var2, String var3);

    private native String nUserName();
}

