/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.java;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;

public class ClassFile {
    private File file;
    private ZipFile zipFile;
    private ZipEntry zipEntry;

    public ClassFile(File file) {
        this.file = file;
    }

    public ClassFile(ZipFile zipFile, ZipEntry zipEntry) {
        this.zipFile = zipFile;
        this.zipEntry = zipEntry;
    }

    public boolean isZipped() {
        return this.zipFile != null;
    }

    public InputStream getInputStream() throws IOException {
        if (this.file != null) {
            return new FileInputStream(this.file);
        }
        try {
            return this.zipFile.getInputStream(this.zipEntry);
        }
        catch (ZipException zipException) {
            throw new IOException(zipException.getMessage());
        }
    }

    public boolean exists() {
        if (this.file != null) {
            return this.file.exists();
        }
        return true;
    }

    public boolean isDirectory() {
        if (this.file != null) {
            return this.file.isDirectory();
        }
        return this.zipEntry.getName().endsWith("/");
    }

    public long lastModified() {
        if (this.file != null) {
            return this.file.lastModified();
        }
        return this.zipEntry.getTime();
    }

    public String getPath() {
        if (this.file != null) {
            return this.file.getPath();
        }
        return String.valueOf(this.zipFile.getName()) + "(" + this.zipEntry.getName() + ")";
    }

    public String getName() {
        if (this.file != null) {
            return this.file.getName();
        }
        return this.zipEntry.getName();
    }

    public String getAbsoluteName() {
        String string;
        if (this.file != null) {
            try {
                string = this.file.getCanonicalPath();
            }
            catch (IOException iOException) {
                string = this.file.getAbsolutePath();
            }
        } else {
            string = String.valueOf(this.zipFile.getName()) + "(" + this.zipEntry.getName() + ")";
        }
        return string;
    }

    public long length() {
        if (this.file != null) {
            return this.file.length();
        }
        return this.zipEntry.getSize();
    }

    public String toString() {
        if (this.file != null) {
            return this.file.toString();
        }
        return this.zipEntry.toString();
    }
}

