/*
 * jutils.h - small utilities for java native code
 * Copyright (c) 1996,97 IICM
 *
 * created: mpichler, 19960924
 * changed: mpichler, 19961003
 *
 * $Id: jutils.h,v 1.4 1997/07/11 10:04:59 mpichler Exp $
 */


#ifndef jutils_h
#define jutils_h


/* concatenation rules (lets assume Ansi C preprocessor) */
#define name2(a,b) name2__(a,b)
#define name2__(a,b) a ## b
#define name3(a,b,c) name3__(a,b,c)
#define name3__(a,b,c) a ## b ## c

/* native data types corresponding to java types:
   Java___  C_________  comment______________________________
   int      jn_int32    32 bit integer (int or long)
   boolean  jn_boolean  same as jn_int32
   short    jn_int16    16 bit integer (short)
   long                 64 bit integer; not all machines support long long
   float    float       32 bit IEEE float
   double   double      64 bit IEEE double
   (to be completed)
*/

#ifndef jn_int32
# ifdef __osf__
#  define jn_int32 int32_t
#  define jn_boolean int32_t
#  define jn_long long
# else
#  define jn_int32 long
#  define jn_boolean long
# endif
#else
/* jn_int32 may be overriden on commandline */
# define jn_boolean jn_int32
#endif
#define jn_int16 short

#endif
