/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.runtime.content;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Hashtable;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.internal.content.XMLContentDescriber;
import org.eclipse.core.internal.content.XMLRootHandler;
import org.eclipse.core.internal.runtime.InternalPlatform;
import org.eclipse.core.internal.runtime.Policy;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentDescription;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class XMLRootElementContentDescriber
extends XMLContentDescriber
implements IExecutableExtension {
    private static final String DTD_TO_FIND = "dtd";
    private static final String ELEMENT_TO_FIND = "element";
    private String dtdToFind = null;
    private String elementToFind = null;
    static /* synthetic */ Class class$0;

    private int checkCriteria(InputSource contents) throws IOException {
        XMLRootHandler xmlHandler = new XMLRootHandler(this.elementToFind != null);
        try {
            if (!xmlHandler.parseContents(contents)) {
                return 0;
            }
        }
        catch (SAXException sAXException) {
            return 0;
        }
        catch (ParserConfigurationException e) {
            String message = Policy.bind("content.parserConfiguration");
            InternalPlatform.getDefault().log(new Status(4, "org.eclipse.core.runtime", 0, message, e));
            throw new RuntimeException(message);
        }
        if (this.elementToFind != null && !this.elementToFind.equals(xmlHandler.getRootName())) {
            return 0;
        }
        if (this.dtdToFind != null && !this.dtdToFind.equals(xmlHandler.getDTD())) {
            return 0;
        }
        return 2;
    }

    public int describe(InputStream contents, IContentDescription description) throws IOException {
        if (super.describe(contents, description) == 0) {
            return 0;
        }
        contents.reset();
        return this.checkCriteria(new InputSource(contents));
    }

    public int describe(Reader contents, IContentDescription description) throws IOException {
        if (super.describe(contents, description) == 0) {
            return 0;
        }
        contents.reset();
        return this.checkCriteria(new InputSource(contents));
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        if (data instanceof String) {
            this.elementToFind = (String)data;
        } else if (data instanceof Hashtable) {
            Hashtable parameters = (Hashtable)data;
            this.dtdToFind = (String)parameters.get(DTD_TO_FIND);
            this.elementToFind = (String)parameters.get(ELEMENT_TO_FIND);
        }
        if (this.dtdToFind == null && this.elementToFind == null) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.core.runtime.content.XMLRootElementContentDescriber");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            String message = Policy.bind("content.badInitializationData", clazz.getName());
            throw new CoreException(new Status(4, "org.eclipse.core.runtime", 0, message, null));
        }
    }
}

