/* DisplayManager.m - Menu suppor class to 
   the Display menu functions for the 
   Macintosh OS X SDL port of Atari800
   Mark Grebe <atarimac@cox.net>
   
   Based on the Preferences pane of the
   TextEdit application.

*/
#import "DisplayManager.h"

extern void SwitchFullscreen(void);
extern int requestDoubleSizeChange;
extern int DOUBLESIZE;
extern int requestWidthModeChange;
extern int WIDTH_MODE;
extern int SHOWFPS;
extern int requestFullScreenChange;
extern int requestFpsChange;
extern int requestGrabMouse;
extern int requestScreenshot;
extern int requestInterlacedScreenshot;

/* Functions which provide an interface for C code to call this object's shared Instance functions */
void SetDisplayManagerDoubleSize(int doubleSize) {
    [[DisplayManager sharedInstance] setDoublesizeMenu:(!doubleSize)];
    }

void SetDisplayManagerWidthMode(int widthMode) {
    [[DisplayManager sharedInstance] setWidthmodeMenu:(widthMode)];
    }

void SetDisplayManagerFps(int fpsOn) {
    [[DisplayManager sharedInstance] setFpsMenu:(fpsOn)];
    }

void SetDisplayManagerGrabMouse(int mouseOn) {
    [[DisplayManager sharedInstance] setGrabmouseMenu:(mouseOn)];
    }

@implementation DisplayManager

static DisplayManager *sharedInstance = nil;

+ (DisplayManager *)sharedInstance {
    return sharedInstance ? sharedInstance : [[self alloc] init];
}

- (id)init {
    if (sharedInstance) {
	[self dealloc];
    } else {
        [super init];
        sharedInstance = self;
    }
    return sharedInstance;
}

- (void)dealloc {
}

/*------------------------------------------------------------------------------
*  setDoublesizeMenu - This method is used to set the menu text for the 
*     single/double size menu item.
*-----------------------------------------------------------------------------*/
- (void)setDoublesizeMenu:(int)doubleSize
{
    static NSString *doubleSizeStr = nil;
    static NSString *singleSizeStr = nil;
    
    if (doubleSizeStr == nil) {
        doubleSizeStr = [[NSString alloc] initWithString:@"Change To Double Size"];
        singleSizeStr = [[NSString alloc] initWithString:@"Change To Single Size"];
        }

    if (doubleSize)	
        [doubleSizeItem setTitle:doubleSizeStr];
    else
        [doubleSizeItem setTitle:singleSizeStr];

}

/*------------------------------------------------------------------------------
*  setWidthmodeMenu - This method is used to set the menu text for the 
*     short/default/full width menu item.
*-----------------------------------------------------------------------------*/
- (void)setWidthmodeMenu:(int)widthMode
{
    static NSString *shortModeStr = nil;
    static NSString *defaultModeStr = nil;
    static NSString *fullModeStr = nil;
    
    if (shortModeStr == nil) {
        shortModeStr = [[NSString alloc] initWithString:@"Change To Default Width"];
        defaultModeStr = [[NSString alloc] initWithString:@"Change To Full Width"];
        fullModeStr = [[NSString alloc] initWithString:@"Change To Short Width"];
        }

    if (widthMode == 0)	
        [widthModeItem setTitle:shortModeStr];
    else if (widthMode == 1)
        [widthModeItem setTitle:defaultModeStr];
    else
        [widthModeItem setTitle:fullModeStr];

}

/*------------------------------------------------------------------------------
*  setWidthmodeMenu - This method is used to set/clear the enabled check for the 
*     Grab mouse menu item.
*-----------------------------------------------------------------------------*/
- (void)setGrabmouseMenu:(int)mouseOn
{
    if (mouseOn)
        [grabMouseItem setTarget:self];
    else
        [grabMouseItem setTarget:nil];
}

/*------------------------------------------------------------------------------
*  setFpsMenu - This method is used to set/clear the enabled check for the 
*     display frames per second menu item.
*-----------------------------------------------------------------------------*/
- (void)setFpsMenu:(int)fpsOn
{
    if (fpsOn)
        [displayFpsItem setState:NSOnState];
    else
        [displayFpsItem setState:NSOffState];
}

/*------------------------------------------------------------------------------
*  doubleSize - This method handles the single/double size menu selection.
*-----------------------------------------------------------------------------*/
- (IBAction)doubleSize:(id)sender
{
    [self setDoublesizeMenu:DOUBLESIZE];
    requestDoubleSizeChange = 1;
}

/*------------------------------------------------------------------------------
*  fullScreen - This method handles the windowed/fullscreen menu selection.
*-----------------------------------------------------------------------------*/
- (IBAction)fullScreen:(id)sender
{
    requestFullScreenChange = 1;
}

/*------------------------------------------------------------------------------
*  displayFps - This method handles the display frames per second menu 
*     selection.
*-----------------------------------------------------------------------------*/
- (IBAction)displayFps:(id)sender
{
    [self setFpsMenu:(1-SHOWFPS)];
    requestFpsChange = 1;
}

/*------------------------------------------------------------------------------
*  displayFps - This method handles the grab mouse menu selection.
*-----------------------------------------------------------------------------*/
- (IBAction)grabMouse:(id)sender;
{
    requestGrabMouse = 1;
}

/*------------------------------------------------------------------------------
*  interlacedScreenshot - This method handles the take interlaced screenshot
*      menu selection.
*-----------------------------------------------------------------------------*/
- (IBAction)interlacedScreenshot:(id)sender
{
    requestInterlacedScreenshot = 1;
}

/*------------------------------------------------------------------------------
*  screenshot - This method handles the take screenshot menu selection.
*-----------------------------------------------------------------------------*/
- (IBAction)screenshot:(id)sender
{
    requestScreenshot = 1;
}

/*------------------------------------------------------------------------------
*  screenshot - This method handles the short/default/full width mode menu 
*       selection.
*-----------------------------------------------------------------------------*/
- (IBAction)widthMode:(id)sender
{
    int newWidthMode = (WIDTH_MODE+1) % 3;
    [self setWidthmodeMenu:newWidthMode];
    requestWidthModeChange = 1;
}

@end
