/*
 * Copyright (C) The Apache Software Foundation. All rights reserved.
 *
 * This software is published under the terms of the Apache Software License
 * version 1.1, a copy of which has been included with this distribution in
 * the LICENSE.txt file.
 */
package org.apache.avalon.excalibur.collections;

import org.apache.avalon.framework.CascadingRuntimeException;

/**
 * The BufferOverflowException is used when the buffer is already empty
 *
 * @author <a href="mailto:bloritsch@apache.org">Berin Loritsch</a>
 */
public class BufferUnderflowException extends CascadingRuntimeException
{

    public BufferUnderflowException( String message )
    {
        super( message, null );
    }

    public BufferUnderflowException( String message, Throwable exception )
    {
        super( message, exception );
    }
}
