/*
 * Copyright (C) The Apache Software Foundation. All rights reserved.
 *
 * This software is published under the terms of the Apache Software License
 * version 1.1, a copy of which has been included with this distribution in
 * the LICENSE.txt file.
 */
package org.apache.avalon.excalibur.naming;

import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameParser;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.spi.InitialContextFactory;
import javax.naming.spi.ObjectFactory;
import javax.naming.spi.StateFactory;

/**
 * This is the default namespace implementation.
 *
 * @author <a href="mailto:peter@apache.org">Peter Donald</a>
 * @version $Revision: 1.6 $
 */
public class DefaultNamespace
    extends AbstractNamespace
{
    private NameParser             m_nameParser;

    public DefaultNamespace( final NameParser nameParser )
    {
        this( nameParser,
              new ObjectFactory[ 0 ],
              new StateFactory[ 0 ] );
    }

    public DefaultNamespace( final NameParser nameParser,
                             final ObjectFactory[] objectFactorySet,
                             final StateFactory[] stateFactorySet )
    {
        m_nameParser = nameParser;
        m_objectFactorySet = objectFactorySet;
        m_stateFactorySet = stateFactorySet;
    }

    public NameParser getNameParser()
    {
        return m_nameParser;
    }

    public synchronized void addStateFactory( final StateFactory stateFactory )
    {
        super.addStateFactory( stateFactory );
    }

    public synchronized void addObjectFactory( final ObjectFactory objectFactory )
    {
        super.addObjectFactory( objectFactory );
    }
}
