/*
 * Copyright (C) The Apache Software Foundation. All rights reserved.
 *
 * This software is published under the terms of the Apache Software License
 * version 1.1, a copy of which has been included with this distribution in
 * the LICENSE.txt file.
 */
package org.apache.avalon.excalibur.source.validity;

import org.apache.avalon.excalibur.source.SourceValidity;

/**
 * A validation object which is always valid.
 *
 * @author <a href="mailto:cziegeler@apache.org">Carsten Ziegeler</a>
 * @version CVS $Revision: 1.2 $ $Date: 2001/12/17 13:20:57 $
 */
public final class NOPValidity
implements SourceValidity {

    public static final SourceValidity SHARED_INSTANCE = new NOPValidity();

    /**
     * Check if the component is still valid.
     * If <code>false</code> is returned the isValid(SourceValidity) must be
     * called afterwards!
     */
    public boolean isValid() {
        return true;
    }

    public boolean isValid(SourceValidity newValidity) {
        return newValidity instanceof NOPValidity;
    }

    public String toString() {
        return "NOPValidity";
    }

}
