/*
 * Copyright (C) The Apache Software Foundation. All rights reserved.
 *
 * This software is published under the terms of the Apache Software License
 * version 1.1, a copy of which has been included with this distribution in
 * the LICENSE.txt file.
 */
package org.apache.avalon.excalibur.vfs;

import java.io.IOException;

/**
 * Interface to read only VFS.
 *
 * @author <a href="mailto:peter@apache.org">Peter Donald</a>
 */
public interface VFileSystem
{
    /**
     * Retrieve VFile by path.
     *
     * @param path the path to VFile
     * @return the VFile (may be null)
     */
    VFile get( String path )
        throws IOException;

    /**
     * List all vfiles in directory.
     * if path is not a directory null will be returned.
     *
     * @param directory the directory
     * @return the VFiles 
     */
    VFile[] list( VFile directory )
        throws IOException;

    /**
     * List all vfiles in directory that are accepted by filter.
     * if path is not a directory null will be returned.
     *
     * @param directory the directory
     * @param filter the filter
     * @return the VFiles accepted by filter
     */
    VFile[] list( VFile directory, VFileFilter filter )
        throws IOException;
}
