/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.diskmanager.file.impl;

import com.aelitis.azureus.core.diskmanager.file.FMFileManagerException;
import com.aelitis.azureus.core.diskmanager.file.FMFileOwner;
import com.aelitis.azureus.core.diskmanager.file.impl.FMFileImpl;
import java.io.File;
import org.gudy.azureus2.core3.util.DirectByteBuffer;

public class FMFileUnlimited
extends FMFileImpl {
    protected FMFileUnlimited(FMFileOwner _owner, File _file) throws FMFileManagerException {
        super(_owner, _file);
    }

    public void setAccessMode(int mode) throws FMFileManagerException {
        try {
            this.this_mon.enter();
            if (mode == this.access_mode && this.raf != null) {
                this.this_mon.exit();
                return;
            }
            this.access_mode = mode;
            if (this.raf != null) {
                this.closeSupport(false);
            }
            this.openSupport();
        }
        finally {
            this.this_mon.exit();
        }
    }

    public long getSize() throws FMFileManagerException {
        try {
            this.this_mon.enter();
            this.ensureOpen();
            long l = this.getSizeSupport();
            this.this_mon.exit();
            return l;
        }
        catch (Throwable throwable) {
            this.this_mon.exit();
            throw throwable;
        }
    }

    public long getLength() throws FMFileManagerException {
        try {
            this.this_mon.enter();
            this.ensureOpen();
            long l = this.getLengthSupport();
            this.this_mon.exit();
            return l;
        }
        catch (Throwable throwable) {
            this.this_mon.exit();
            throw throwable;
        }
    }

    public void setLength(long length) throws FMFileManagerException {
        try {
            this.this_mon.enter();
            this.ensureOpen();
            this.setLengthSupport(length);
        }
        finally {
            this.this_mon.exit();
        }
    }

    public void read(DirectByteBuffer buffer, long offset) throws FMFileManagerException {
        try {
            this.this_mon.enter();
            this.ensureOpen();
            this.readSupport(buffer, offset);
        }
        finally {
            this.this_mon.exit();
        }
    }

    public void write(DirectByteBuffer buffer, long position) throws FMFileManagerException {
        try {
            this.this_mon.enter();
            this.ensureOpen();
            this.writeSupport(buffer, position);
        }
        finally {
            this.this_mon.exit();
        }
    }

    public void write(DirectByteBuffer[] buffers, long position) throws FMFileManagerException {
        try {
            this.this_mon.enter();
            this.ensureOpen();
            this.writeSupport(buffers, position);
        }
        finally {
            this.this_mon.exit();
        }
    }

    public void close() throws FMFileManagerException {
        try {
            this.this_mon.enter();
            this.closeSupport(true);
        }
        finally {
            this.this_mon.exit();
        }
    }
}

