/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.tracker.host.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentException;
import org.gudy.azureus2.core3.tracker.host.TRHostException;
import org.gudy.azureus2.core3.tracker.host.TRHostPeer;
import org.gudy.azureus2.core3.tracker.host.TRHostTorrent;
import org.gudy.azureus2.core3.tracker.host.TRHostTorrentListener;
import org.gudy.azureus2.core3.tracker.host.TRHostTorrentRemovalVetoException;
import org.gudy.azureus2.core3.tracker.host.TRHostTorrentRequest;
import org.gudy.azureus2.core3.tracker.host.TRHostTorrentWillBeRemovedListener;
import org.gudy.azureus2.core3.tracker.host.impl.TRHostImpl;
import org.gudy.azureus2.core3.tracker.host.impl.TRHostPeerHostImpl;
import org.gudy.azureus2.core3.tracker.server.TRTrackerServer;
import org.gudy.azureus2.core3.tracker.server.TRTrackerServerPeer;
import org.gudy.azureus2.core3.tracker.server.TRTrackerServerTorrent;
import org.gudy.azureus2.core3.tracker.server.TRTrackerServerTorrentStats;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.Average;
import org.gudy.azureus2.core3.util.Debug;

public class TRHostTorrentHostImpl
implements TRHostTorrent {
    protected TRHostImpl host;
    protected TRTrackerServer server;
    protected TRTrackerServerTorrent server_torrent;
    protected TOTorrent torrent;
    protected int port;
    protected List listeners = new ArrayList();
    protected List removal_listeners = new ArrayList();
    protected int status = 1;
    protected boolean persistent;
    protected long sos_uploaded;
    protected long sos_downloaded;
    protected long sos_bytes_in;
    protected long sos_bytes_out;
    protected long last_uploaded;
    protected long last_downloaded;
    protected long last_bytes_in;
    protected long last_bytes_out;
    protected Average average_uploaded = Average.getInstance(60000, 600);
    protected Average average_downloaded = Average.getInstance(60000, 600);
    protected Average average_bytes_in = Average.getInstance(60000, 600);
    protected Average average_bytes_out = Average.getInstance(60000, 600);
    protected boolean disable_reply_caching;
    private HashMap data;
    protected AEMonitor this_mon = new AEMonitor("TRHostTorrentHost");

    protected TRHostTorrentHostImpl(TRHostImpl _host, TRTrackerServer _server, TOTorrent _torrent, int _port) {
        this.host = _host;
        this.server = _server;
        this.torrent = _torrent;
        this.port = _port;
    }

    public int getPort() {
        return this.port;
    }

    public void start() {
        this.host.startTorrent(this);
    }

    protected void startSupport() {
        try {
            try {
                this.this_mon.enter();
                this.status = 2;
                this.server_torrent = this.server.permit(this.torrent.getHash(), true);
                if (this.disable_reply_caching) {
                    this.server_torrent.disableCaching();
                }
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
        finally {
            this.this_mon.exit();
        }
        this.host.hostTorrentStateChange(this);
    }

    public void stop() {
        this.host.stopTorrent(this);
    }

    protected void stopSupport() {
        try {
            try {
                TRTrackerServerTorrentStats torrent_stats;
                this.this_mon.enter();
                this.status = 1;
                this.server.deny(this.torrent.getHash(), true);
                TRTrackerServerTorrent st = this.server_torrent;
                TRTrackerServerTorrentStats tRTrackerServerTorrentStats = torrent_stats = st == null ? null : st.getStats();
                if (torrent_stats != null) {
                    this.sos_uploaded += torrent_stats.getUploaded();
                    this.sos_downloaded += torrent_stats.getDownloaded();
                    this.sos_bytes_in += torrent_stats.getBytesIn();
                    this.sos_bytes_out += torrent_stats.getBytesOut();
                    torrent_stats = null;
                }
                this.last_uploaded = 0L;
                this.last_downloaded = 0L;
                this.last_bytes_in = 0L;
                this.last_bytes_out = 0L;
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
        finally {
            this.this_mon.exit();
        }
        this.host.hostTorrentStateChange(this);
    }

    public void remove() throws TRHostTorrentRemovalVetoException {
        this.canBeRemoved();
        this.stop();
        this.host.remove(this);
    }

    public boolean canBeRemoved() throws TRHostTorrentRemovalVetoException {
        ArrayList listeners_copy;
        try {
            this.this_mon.enter();
            listeners_copy = new ArrayList(this.removal_listeners);
        }
        finally {
            this.this_mon.exit();
        }
        int i = 0;
        while (i < listeners_copy.size()) {
            ((TRHostTorrentWillBeRemovedListener)listeners_copy.get(i)).torrentWillBeRemoved(this);
            ++i;
        }
        return true;
    }

    public int getStatus() {
        return this.status;
    }

    public boolean isPersistent() {
        return this.persistent;
    }

    public void setPersistent(boolean _persistent) {
        this.persistent = _persistent;
    }

    public TOTorrent getTorrent() {
        return this.torrent;
    }

    protected void setTorrent(TOTorrent _torrent) {
        this.torrent = _torrent;
    }

    public TRHostPeer[] getPeers() {
        try {
            TRTrackerServerPeer[] peers = this.server.getPeers(this.torrent.getHash());
            if (peers != null) {
                TRHostPeer[] res = new TRHostPeer[peers.length];
                int i = 0;
                while (i < peers.length) {
                    res[i] = new TRHostPeerHostImpl(peers[i]);
                    ++i;
                }
                return res;
            }
        }
        catch (TOTorrentException e) {
            Debug.printStackTrace(e);
        }
        return new TRHostPeer[0];
    }

    protected TRTrackerServerTorrentStats getStats() {
        TRTrackerServerTorrent st = this.server_torrent;
        if (st != null) {
            return st.getStats();
        }
        return null;
    }

    protected void setStartOfDayValues(long completed, long announces, long scrapes, long uploaded, long downloaded, long bytes_in, long bytes_out) {
        TRTrackerServerTorrentStats stats = this.getStats();
        if (stats != null) {
            stats.setCompletedCount(completed);
            stats.setAnnounceCount(announces);
            stats.setScrapeCount(scrapes);
        }
        this.sos_uploaded = uploaded;
        this.sos_downloaded = downloaded;
        this.sos_bytes_in = bytes_in;
        this.sos_bytes_out = bytes_out;
    }

    public int getSeedCount() {
        TRTrackerServerTorrentStats stats = this.getStats();
        if (stats != null) {
            return stats.getSeedCount();
        }
        return 0;
    }

    public int getLeecherCount() {
        TRTrackerServerTorrentStats stats = this.getStats();
        if (stats != null) {
            return stats.getLeecherCount();
        }
        return 0;
    }

    public int getBadNATCount() {
        TRTrackerServerTorrentStats stats = this.getStats();
        if (stats != null) {
            return stats.getBadNATPeerCount();
        }
        return 0;
    }

    public long getAnnounceCount() {
        TRTrackerServerTorrentStats stats = this.getStats();
        if (stats != null) {
            return stats.getAnnounceCount();
        }
        return 0L;
    }

    public long getScrapeCount() {
        TRTrackerServerTorrentStats stats = this.getStats();
        if (stats != null) {
            return stats.getScrapeCount();
        }
        return 0L;
    }

    public long getCompletedCount() {
        TRTrackerServerTorrentStats stats = this.getStats();
        if (stats != null) {
            return stats.getCompletedCount();
        }
        return 0L;
    }

    protected void updateStats() {
        TRTrackerServerTorrentStats stats = this.getStats();
        if (stats != null) {
            long current_uploaded = stats.getUploaded();
            long ul_diff = current_uploaded - this.last_uploaded;
            if (ul_diff < 0L) {
                ul_diff = 0L;
            }
            this.average_uploaded.addValue((int)ul_diff);
            this.last_uploaded = current_uploaded;
            long current_downloaded = stats.getDownloaded();
            long dl_diff = current_downloaded - this.last_downloaded;
            if (dl_diff < 0L) {
                dl_diff = 0L;
            }
            this.average_downloaded.addValue((int)dl_diff);
            this.last_downloaded = current_downloaded;
            long current_bytes_in = stats.getBytesIn();
            long bi_diff = current_bytes_in - this.last_bytes_in;
            if (bi_diff < 0L) {
                bi_diff = 0L;
            }
            this.average_bytes_in.addValue((int)bi_diff);
            this.last_bytes_in = current_bytes_in;
            long current_bytes_out = stats.getBytesOut();
            long bo_diff = current_bytes_out - this.last_bytes_out;
            if (bo_diff < 0L) {
                bo_diff = 0L;
            }
            this.average_bytes_out.addValue((int)bo_diff);
            this.last_bytes_out = current_bytes_out;
        }
    }

    protected TRTrackerServer getServer() {
        return this.server;
    }

    public long getTotalUploaded() {
        TRTrackerServerTorrentStats stats = this.getStats();
        if (stats != null) {
            return this.sos_uploaded + stats.getUploaded();
        }
        return this.sos_uploaded;
    }

    public long getTotalDownloaded() {
        TRTrackerServerTorrentStats stats = this.getStats();
        if (stats != null) {
            return this.sos_downloaded + stats.getDownloaded();
        }
        return this.sos_downloaded;
    }

    public long getTotalLeft() {
        TRTrackerServerTorrentStats stats = this.getStats();
        if (stats != null) {
            return stats.getAmountLeft();
        }
        return 0L;
    }

    public long getTotalBytesIn() {
        TRTrackerServerTorrentStats stats = this.getStats();
        if (stats != null) {
            return this.sos_bytes_in + stats.getBytesIn();
        }
        return this.sos_bytes_in;
    }

    public long getTotalBytesOut() {
        TRTrackerServerTorrentStats stats = this.getStats();
        if (stats != null) {
            return this.sos_bytes_out + stats.getBytesOut();
        }
        return this.sos_bytes_out;
    }

    public long getAverageBytesIn() {
        return this.average_bytes_in.getAverage();
    }

    public long getAverageBytesOut() {
        return this.average_bytes_out.getAverage();
    }

    public long getAverageUploaded() {
        return this.average_uploaded.getAverage();
    }

    public long getAverageDownloaded() {
        return this.average_downloaded.getAverage();
    }

    public void disableReplyCaching() {
        TRTrackerServerTorrent st = this.server_torrent;
        this.disable_reply_caching = true;
        if (st != null) {
            st.disableCaching();
        }
    }

    protected void postProcess(TRHostTorrentRequest req) throws TRHostException {
        ArrayList listeners_copy;
        try {
            this.this_mon.enter();
            listeners_copy = new ArrayList(this.listeners);
        }
        finally {
            this.this_mon.exit();
        }
        int i = 0;
        while (i < listeners_copy.size()) {
            ((TRHostTorrentListener)listeners_copy.get(i)).postProcess(req);
            ++i;
        }
    }

    public void addListener(TRHostTorrentListener l) {
        try {
            this.this_mon.enter();
            this.listeners.add(l);
        }
        finally {
            this.this_mon.exit();
        }
        this.host.torrentListenerRegistered();
    }

    public void removeListener(TRHostTorrentListener l) {
        try {
            this.this_mon.enter();
            this.listeners.remove(l);
        }
        finally {
            this.this_mon.exit();
        }
    }

    public void addRemovalListener(TRHostTorrentWillBeRemovedListener l) {
        try {
            this.this_mon.enter();
            this.removal_listeners.add(l);
        }
        finally {
            this.this_mon.exit();
        }
    }

    public void removeRemovalListener(TRHostTorrentWillBeRemovedListener l) {
        try {
            this.this_mon.enter();
            this.removal_listeners.remove(l);
        }
        finally {
            this.this_mon.exit();
        }
    }

    public Object getData(String key) {
        if (this.data == null) {
            return null;
        }
        return this.data.get(key);
    }

    public void setData(String key, Object value) {
        try {
            this.this_mon.enter();
            if (this.data == null) {
                this.data = new HashMap();
            }
            if (value == null) {
                if (this.data.containsKey(key)) {
                    this.data.remove(key);
                }
            } else {
                this.data.put(key, value);
            }
        }
        finally {
            this.this_mon.exit();
        }
    }
}

