/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.gudy.azureus2.core3.logging.LGLogger;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.Plugin;
import org.gudy.azureus2.plugins.PluginConfig;
import org.gudy.azureus2.plugins.PluginEvent;
import org.gudy.azureus2.plugins.PluginEventListener;
import org.gudy.azureus2.plugins.PluginException;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.PluginListener;
import org.gudy.azureus2.plugins.PluginManager;
import org.gudy.azureus2.plugins.PluginView;
import org.gudy.azureus2.plugins.UnloadablePlugin;
import org.gudy.azureus2.plugins.download.DownloadManager;
import org.gudy.azureus2.plugins.ipfilter.IPFilter;
import org.gudy.azureus2.plugins.logging.Logger;
import org.gudy.azureus2.plugins.peers.protocol.PeerProtocolManager;
import org.gudy.azureus2.plugins.sharing.ShareException;
import org.gudy.azureus2.plugins.sharing.ShareManager;
import org.gudy.azureus2.plugins.torrent.TorrentManager;
import org.gudy.azureus2.plugins.tracker.Tracker;
import org.gudy.azureus2.plugins.ui.UIManager;
import org.gudy.azureus2.plugins.ui.config.ConfigSection;
import org.gudy.azureus2.plugins.ui.config.Parameter;
import org.gudy.azureus2.plugins.ui.config.PluginConfigUIFactory;
import org.gudy.azureus2.plugins.ui.tables.mytorrents.PluginMyTorrentsItemFactory;
import org.gudy.azureus2.plugins.ui.tables.peers.PluginPeerItemFactory;
import org.gudy.azureus2.plugins.update.UpdateManager;
import org.gudy.azureus2.plugins.utils.ShortCuts;
import org.gudy.azureus2.plugins.utils.Utilities;
import org.gudy.azureus2.pluginsimpl.local.PluginConfigImpl;
import org.gudy.azureus2.pluginsimpl.local.PluginInitializer;
import org.gudy.azureus2.pluginsimpl.local.download.DownloadManagerImpl;
import org.gudy.azureus2.pluginsimpl.local.installer.PluginInstallerImpl;
import org.gudy.azureus2.pluginsimpl.local.ipfilter.IPFilterImpl;
import org.gudy.azureus2.pluginsimpl.local.logging.LoggerImpl;
import org.gudy.azureus2.pluginsimpl.local.peers.protocol.PeerProtocolManagerImpl;
import org.gudy.azureus2.pluginsimpl.local.sharing.ShareManagerImpl;
import org.gudy.azureus2.pluginsimpl.local.torrent.TorrentManagerImpl;
import org.gudy.azureus2.pluginsimpl.local.tracker.TrackerImpl;
import org.gudy.azureus2.pluginsimpl.local.ui.UIManagerImpl;
import org.gudy.azureus2.pluginsimpl.local.ui.config.ConfigSectionRepository;
import org.gudy.azureus2.pluginsimpl.local.ui.config.ParameterRepository;
import org.gudy.azureus2.pluginsimpl.local.ui.config.PluginConfigUIFactoryImpl;
import org.gudy.azureus2.pluginsimpl.local.update.UpdateManagerImpl;
import org.gudy.azureus2.pluginsimpl.local.utils.ShortCutsImpl;
import org.gudy.azureus2.pluginsimpl.local.utils.UtilitiesImpl;
import org.gudy.azureus2.ui.swt.FileDownloadWindow;
import org.gudy.azureus2.ui.swt.mainwindow.MainWindow;
import org.gudy.azureus2.ui.swt.mainwindow.TorrentOpener;
import org.gudy.azureus2.ui.swt.views.table.utils.TableColumnManager;

public class PluginInterfaceImpl
implements PluginInterface {
    protected Plugin plugin;
    protected PluginInitializer initialiser;
    protected Object initialiser_key;
    protected ClassLoader class_loader;
    protected List listeners = new ArrayList();
    protected List event_listeners = new ArrayList();
    protected String pluginConfigKey;
    protected Properties props;
    protected String pluginDir;
    protected PluginConfig config;
    protected String plugin_id;
    protected String plugin_version;
    protected boolean operational;
    protected Logger logger;

    public PluginInterfaceImpl(Plugin _plugin, PluginInitializer _initialiser, Object _initialiser_key, ClassLoader _class_loader, String _key, Properties _props, String _pluginDir, String _plugin_id, String _plugin_version) {
        this.plugin = _plugin;
        this.initialiser = _initialiser;
        this.initialiser_key = _initialiser_key;
        this.class_loader = _class_loader;
        this.pluginConfigKey = "Plugin." + _key;
        this.props = new propertyWrapper(_props);
        this.pluginDir = _pluginDir;
        this.config = new PluginConfigImpl(this.pluginConfigKey);
        this.plugin_id = _plugin_id;
        this.plugin_version = _plugin_version;
    }

    public Plugin getPlugin() {
        return this.plugin;
    }

    protected void setOperational(boolean b) {
        this.operational = b;
    }

    public boolean isOperational() {
        return this.operational;
    }

    public Object getInitializerKey() {
        return this.initialiser_key;
    }

    public PluginManager getPluginManager() {
        return this.initialiser.getPluginManager();
    }

    public String getAzureusName() {
        return "Azureus";
    }

    public String getAzureusVersion() {
        return "2.2.0.2";
    }

    public void addView(PluginView view) {
        this.getUIManager().getSWTManager().addView(view);
    }

    public void addConfigSection(ConfigSection section) {
        ConfigSectionRepository.getInstance().addConfigSection(section);
    }

    public void openTorrentFile(String fileName) {
        TorrentOpener.openTorrent(this.initialiser.getAzureusCore(), fileName);
    }

    public void openTorrentURL(String url) {
        new FileDownloadWindow(this.initialiser.getAzureusCore(), MainWindow.getWindow().getDisplay(), url, null);
    }

    public void setPluginName(String name) {
        this.props.put("plugin.name", name);
    }

    public String getPluginName() {
        String name = null;
        if (this.props != null) {
            name = (String)this.props.get("plugin.name");
        }
        if (name == null) {
            try {
                name = new File(this.pluginDir).getName();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (name == null || name.length() == 0) {
            name = this.plugin.getClass().getName();
        }
        return name;
    }

    public void setPluginVersion(String version) {
        this.props.put("plugin.version", version);
    }

    public String getPluginVersion() {
        String version = (String)this.props.get("plugin.version");
        if (version == null) {
            version = this.plugin_version;
        }
        return version;
    }

    public String getPluginID() {
        String id = (String)this.props.get("plugin.id");
        if (id == null) {
            id = this.plugin_id;
        }
        return id == null ? "<none>" : id;
    }

    public boolean isMandatory() {
        String mand = this.getPluginProperties().getProperty("plugin.mandatory");
        return mand != null && mand.trim().toLowerCase().equals("true");
    }

    public boolean isBuiltIn() {
        return this.getPluginDirectoryName().length() == 0;
    }

    public Properties getPluginProperties() {
        return this.props;
    }

    public String getPluginDirectoryName() {
        return this.pluginDir;
    }

    public void setPluginDirectoryName(String name) {
        this.initialiser_key = new File(name);
        this.pluginDir = name;
    }

    public void addConfigUIParameters(Parameter[] parameters, String displayName) {
        ParameterRepository.getInstance().addPlugin(parameters, displayName);
    }

    public PluginConfig getPluginconfig() {
        return this.config;
    }

    public PluginConfigUIFactory getPluginConfigUIFactory() {
        return new PluginConfigUIFactoryImpl(this.config, this.pluginConfigKey);
    }

    public String getPluginConfigKey() {
        return this.pluginConfigKey;
    }

    public void addColumnToPeersTable(String columnName, PluginPeerItemFactory item) {
        TableColumnManager.getInstance().addExtension(columnName, item);
    }

    public void addColumnToMyTorrentsTable(String columnName, PluginMyTorrentsItemFactory item) {
        TableColumnManager.getInstance().addExtension(columnName, item);
    }

    public Tracker getTracker() {
        return TrackerImpl.getSingleton();
    }

    public ShareManager getShareManager() throws ShareException {
        return ShareManagerImpl.getSingleton();
    }

    public DownloadManager getDownloadManager() {
        return DownloadManagerImpl.getSingleton(this.initialiser.getAzureusCore());
    }

    public TorrentManager getTorrentManager() {
        return TorrentManagerImpl.getSingleton();
    }

    public Logger getLogger() {
        if (this.logger == null) {
            this.logger = new LoggerImpl();
        }
        return this.logger;
    }

    public IPFilter getIPFilter() {
        return new IPFilterImpl();
    }

    public Utilities getUtilities() {
        return new UtilitiesImpl(this);
    }

    public ShortCuts getShortCuts() {
        return new ShortCutsImpl(this);
    }

    public UIManager getUIManager() {
        return new UIManagerImpl(this);
    }

    public UpdateManager getUpdateManager() {
        return UpdateManagerImpl.getSingleton(this.initialiser.getAzureusCore());
    }

    public PeerProtocolManager getPeerProtocolManager() {
        return PeerProtocolManagerImpl.getSingleton();
    }

    public boolean isUnloadable() {
        String dir = this.getPluginDirectoryName();
        if (dir == null || dir.length() == 0) {
            return this.getPlugin() instanceof UnloadablePlugin;
        }
        List pis = PluginInitializer.getPluginInterfaces();
        int i = 0;
        while (i < pis.size()) {
            PluginInterface pi = (PluginInterface)pis.get(i);
            String other_dir = pi.getPluginDirectoryName();
            if (other_dir != null && other_dir.length() != 0 && dir.equals(other_dir) && !(pi.getPlugin() instanceof UnloadablePlugin)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void unload() throws PluginException {
        if (!this.isUnloadable()) {
            throw new PluginException("Plugin isn't unloadable");
        }
        String dir = this.getPluginDirectoryName();
        if (dir == null || dir.length() == 0) {
            ((UnloadablePlugin)this.getPlugin()).unload();
            this.initialiser.unloadPlugin(this);
        } else {
            ArrayList pis = new ArrayList(PluginInitializer.getPluginInterfaces());
            int i = 0;
            while (i < pis.size()) {
                PluginInterfaceImpl pi = (PluginInterfaceImpl)pis.get(i);
                String other_dir = pi.getPluginDirectoryName();
                if (other_dir != null && other_dir.length() != 0 && dir.equals(other_dir)) {
                    ((UnloadablePlugin)pi.getPlugin()).unload();
                    this.initialiser.unloadPlugin(pi);
                }
                ++i;
            }
        }
    }

    public void reload() throws PluginException {
        this.unload();
        this.initialiser.reloadPlugin(this);
    }

    public void uninstall() throws PluginException {
        PluginInstallerImpl.getSingleton(this.getPluginManager()).uninstall(this);
    }

    protected void initialisationComplete() {
        int i = 0;
        while (i < this.listeners.size()) {
            try {
                ((PluginListener)this.listeners.get(i)).initializationComplete();
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
            ++i;
        }
    }

    protected void closedownInitiated() {
        int i = 0;
        while (i < this.listeners.size()) {
            try {
                ((PluginListener)this.listeners.get(i)).closedownInitiated();
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
            ++i;
        }
    }

    protected void closedownComplete() {
        int i = 0;
        while (i < this.listeners.size()) {
            try {
                ((PluginListener)this.listeners.get(i)).closedownComplete();
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
            ++i;
        }
    }

    protected void fireEvent(PluginEvent event) {
        int i = 0;
        while (i < this.event_listeners.size()) {
            try {
                ((PluginEventListener)this.event_listeners.get(i)).handleEvent(event);
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
            ++i;
        }
    }

    public ClassLoader getPluginClassLoader() {
        return this.class_loader;
    }

    public void addListener(PluginListener l) {
        this.listeners.add(l);
        if (this.initialiser.isInitialisationComplete()) {
            l.initializationComplete();
        }
    }

    public void removeListener(PluginListener l) {
        this.listeners.remove(l);
    }

    public void addEventListener(PluginEventListener l) {
        this.event_listeners.add(l);
    }

    public void removeEventListener(PluginEventListener l) {
        this.event_listeners.remove(l);
    }

    protected class propertyWrapper
    extends Properties {
        protected boolean initialising = true;

        protected propertyWrapper(Properties _props) {
            Iterator<Object> it = _props.keySet().iterator();
            while (it.hasNext()) {
                Object key = it.next();
                this.put(key, _props.get(key));
            }
            this.initialising = false;
        }

        public Object setProperty(String str, String val) {
            if (!PluginInterfaceImpl.this.plugin.getClass().getName().startsWith("org.gudy") && (str.equalsIgnoreCase("plugin.id") || str.equalsIgnoreCase("plugin.version"))) {
                LGLogger.log(0, "Plugin '" + PluginInterfaceImpl.this.getPluginName() + "' tried to set property '" + str + "' - action ignored");
                return null;
            }
            return super.setProperty(str, val);
        }

        public Object put(Object key, Object value) {
            String k_str;
            if (!PluginInterfaceImpl.this.plugin.getClass().getName().startsWith("org.gudy") && !this.initialising && key instanceof String && ((k_str = (String)key).equalsIgnoreCase("plugin.id") || k_str.equalsIgnoreCase("plugin.version"))) {
                LGLogger.log(0, "Plugin '" + PluginInterfaceImpl.this.getPluginName() + "' tried to set property '" + k_str + "' - action ignored");
                return null;
            }
            return super.put(key, value);
        }

        public Object get(Object key) {
            return super.get(key);
        }
    }
}

