/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.installer;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.Plugin;
import org.gudy.azureus2.plugins.PluginException;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.installer.FilePluginInstaller;
import org.gudy.azureus2.plugins.installer.PluginInstaller;
import org.gudy.azureus2.plugins.update.UpdatableComponent;
import org.gudy.azureus2.plugins.update.UpdateCheckInstance;
import org.gudy.azureus2.plugins.update.UpdateChecker;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloader;
import org.gudy.azureus2.pluginsimpl.local.installer.InstallablePluginImpl;
import org.gudy.azureus2.pluginsimpl.local.installer.PluginInstallerImpl;
import org.gudy.azureus2.pluginsimpl.update.PluginUpdatePlugin;
import org.gudy.azureus2.pluginsimpl.update.sf.SFPluginDetailsLoader;
import org.gudy.azureus2.pluginsimpl.update.sf.SFPluginDetailsLoaderFactory;

public class FilePluginInstallerImpl
implements FilePluginInstaller,
InstallablePluginImpl {
    protected PluginInstallerImpl installer;
    protected File file;
    protected String id;
    protected String version;
    protected boolean is_jar;

    protected FilePluginInstallerImpl(PluginInstallerImpl _installer, File _file) throws PluginException {
        this.installer = _installer;
        this.file = _file;
        String name = this.file.getName();
        int pos = name.lastIndexOf(".");
        boolean ok = false;
        if (pos != -1) {
            String prefix = name.substring(0, pos);
            String suffix = name.substring(pos + 1);
            if (suffix.toLowerCase().equals("jar") || suffix.toLowerCase().equals("zip")) {
                this.is_jar = suffix.toLowerCase().equals("jar");
                Properties properties = null;
                ZipInputStream zis = null;
                try {
                    try {
                        zis = new ZipInputStream(new BufferedInputStream(new FileInputStream(this.file)));
                        block13: while (properties == null) {
                            ZipEntry entry2 = zis.getNextEntry();
                            if (entry2 == null) {
                                break;
                            }
                            String zip_name = entry2.getName().toLowerCase();
                            if (zip_name.equals("plugin.properties")) {
                                properties = new Properties();
                                properties.load(zis);
                                continue;
                            }
                            if (!zip_name.endsWith(".jar")) continue;
                            ZipInputStream zis2 = new ZipInputStream(zis);
                            while (properties == null) {
                                ZipEntry entry22 = zis2.getNextEntry();
                                if (entry22 == null) continue block13;
                                String zip_name2 = entry22.getName().toLowerCase();
                                if (!zip_name2.equals("plugin.properties")) continue;
                                properties = new Properties();
                                properties.load(zis2);
                            }
                        }
                    }
                    catch (Throwable e) {
                        throw new PluginException("Failed to read plugin file", e);
                    }
                }
                finally {
                    if (zis != null) {
                        try {
                            zis.close();
                        }
                        catch (Throwable e) {
                            Debug.printStackTrace(e);
                        }
                    }
                }
                if (properties == null) {
                    throw new PluginException("Mandatory file 'plugin.properties' not found in plugin file");
                }
                this.id = properties.getProperty("plugin.id");
                this.version = properties.getProperty("plugin.version");
                if (this.id == null) {
                    String plugin_classes;
                    String plugin_class = properties.getProperty("plugin.class");
                    if (plugin_class == null && (plugin_classes = properties.getProperty("plugin.classes")) != null) {
                        int semi_pos = plugin_classes.indexOf(";");
                        plugin_class = semi_pos == -1 ? plugin_classes : plugin_classes.substring(0, semi_pos);
                    }
                    if (plugin_class != null) {
                        try {
                            PluginInterface pi = this.installer.getPluginManager().getPluginInterfaceByClass(plugin_class);
                            if (pi != null) {
                                this.id = pi.getPluginID();
                            }
                        }
                        catch (Throwable pi) {
                            // empty catch block
                        }
                    }
                }
                if ((pos = prefix.lastIndexOf("_")) != -1) {
                    this.id = this.id == null ? prefix.substring(0, pos) : this.id;
                    try {
                        SFPluginDetailsLoader loader = SFPluginDetailsLoaderFactory.getSingleton();
                        String[] ids = loader.getPluginIDs();
                        int i = 0;
                        while (i < ids.length) {
                            if (ids[i].equalsIgnoreCase(this.id)) {
                                this.id = ids[i];
                                break;
                            }
                            ++i;
                        }
                    }
                    catch (Throwable e) {
                        Debug.printStackTrace(e);
                    }
                    this.version = this.version == null ? prefix.substring(pos + 1) : this.version;
                }
                boolean bl = ok = this.id != null && this.version != null;
            }
        }
        if (!ok) {
            throw new PluginException("Invalid plugin file name: must be of form <pluginid>_<version>.[jar|zip]");
        }
    }

    public File getFile() {
        return this.file;
    }

    public String getId() {
        return this.id;
    }

    public String getVersion() {
        return this.version;
    }

    public String getName() {
        return "";
    }

    public String getDescription() {
        return this.file.toString();
    }

    public PluginInterface getAlreadyInstalledPlugin() {
        return this.installer.getAlreadyInstalledPlugin(this.getId());
    }

    public void install(boolean shared) throws PluginException {
        this.installer.install(this, shared);
    }

    public void uninstall() throws PluginException {
        this.installer.uninstall(this);
    }

    public PluginInstaller getInstaller() {
        return this.installer;
    }

    public void addUpdate(UpdateCheckInstance inst, final PluginUpdatePlugin plugin_update_plugin, Plugin plugin, final PluginInterface plugin_interface) {
        inst.addUpdatableComponent(new UpdatableComponent(){

            public String getName() {
                return FilePluginInstallerImpl.this.file.getName();
            }

            public int getMaximumCheckTime() {
                return 0;
            }

            public void checkForUpdate(UpdateChecker checker) {
                try {
                    ResourceDownloader rd = plugin_interface.getUtilities().getResourceDownloaderFactory().create(FilePluginInstallerImpl.this.file);
                    plugin_update_plugin.addUpdate(plugin_interface, checker, this.getName(), new String[]{"Installation from file: " + FilePluginInstallerImpl.this.file.toString()}, FilePluginInstallerImpl.this.version, rd, FilePluginInstallerImpl.this.is_jar, plugin_interface.isUnloadable() ? 1 : 2);
                }
                finally {
                    checker.completed();
                }
            }
        }, false);
    }
}

