/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt;

import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SHA1Hasher;
import org.gudy.azureus2.ui.swt.ImageRepository;
import org.gudy.azureus2.ui.swt.TrayWindow;
import org.gudy.azureus2.ui.swt.mainwindow.MainWindow;

public class PasswordWindow {
    private Shell shell;
    private static int nbInstances = 0;
    protected static AEMonitor class_mon = new AEMonitor("PasswordWindow:class");

    public static void showPasswordWindow(Display display) {
        try {
            class_mon.enter();
            if (nbInstances == 0) {
                new PasswordWindow(display);
            }
        }
        finally {
            class_mon.exit();
        }
    }

    protected PasswordWindow(Display display) {
        ++nbInstances;
        this.shell = new Shell(display, 65632);
        this.shell.setText(MessageText.getString("PasswordWindow.title"));
        if (!Constants.isOSX) {
            this.shell.setImage(ImageRepository.getImage("azureus"));
        }
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = true;
        this.shell.setLayout((Layout)layout);
        Label label = new Label((Composite)this.shell, 0);
        label.setText(MessageText.getString("PasswordWindow.passwordprotected"));
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        label.setLayoutData((Object)gridData);
        final Text password = new Text((Composite)this.shell, 2048);
        password.setEchoChar('*');
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        password.setLayoutData((Object)gridData);
        Button ok = new Button((Composite)this.shell, 8);
        ok.setText(MessageText.getString("Button.ok"));
        gridData = new GridData(64);
        gridData.widthHint = 70;
        ok.setLayoutData((Object)gridData);
        this.shell.setDefaultButton(ok);
        ok.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                try {
                    SHA1Hasher hasher = new SHA1Hasher();
                    byte[] passwordText = password.getText().getBytes();
                    byte[] encoded = hasher.calculateHash(passwordText);
                    byte[] correct = COConfigurationManager.getByteParameter("Password", "".getBytes());
                    boolean same = true;
                    int i = 0;
                    while (i < correct.length) {
                        if (correct[i] != encoded[i]) {
                            same = false;
                        }
                        ++i;
                    }
                    if (same) {
                        MainWindow.getWindow().setVisible(true);
                        TrayWindow tw = MainWindow.getWindow().getTray();
                        if (tw != null) {
                            tw.setVisible(false);
                            tw.setMoving(false);
                        }
                        PasswordWindow.this.shell.dispose();
                    } else {
                        PasswordWindow.this.close();
                    }
                }
                catch (Exception e) {
                    Debug.printStackTrace(e);
                }
            }
        });
        Button cancel = new Button((Composite)this.shell, 8);
        cancel.setText(MessageText.getString("Button.cancel"));
        gridData = new GridData(64);
        gridData.widthHint = 70;
        cancel.setLayoutData((Object)gridData);
        cancel.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                PasswordWindow.this.close();
            }
        });
        this.shell.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent arg0) {
                nbInstances = nbInstances - 1;
            }
        });
        this.shell.addListener(21, new Listener(){

            public void handleEvent(Event arg0) {
                PasswordWindow.this.close();
            }
        });
        this.shell.pack();
        this.shell.open();
    }

    private void close() {
        this.shell.dispose();
        if (Constants.isOSX) {
            MainWindow.getWindow().getShell().setMinimized(true);
            MainWindow.getWindow().getShell().setVisible(true);
        }
    }
}

