/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.config;

import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SHA1Hasher;
import org.gudy.azureus2.ui.swt.config.Parameter;

public class PasswordParameter
extends Parameter {
    String name;
    Text inputField;

    public PasswordParameter(Composite composite, String name) {
        this(composite, name, true);
    }

    public PasswordParameter(Composite composite, final String name, final boolean sha1) {
        this.name = name;
        this.inputField = new Text(composite, 2048);
        this.inputField.setEchoChar('*');
        byte[] value = COConfigurationManager.getByteParameter(name, "".getBytes());
        if (value.length > 0) {
            this.inputField.setText("***");
        }
        this.inputField.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                try {
                    SHA1Hasher hasher = new SHA1Hasher();
                    byte[] password = PasswordParameter.this.inputField.getText().getBytes();
                    byte[] encoded = password.length > 0 && sha1 ? hasher.calculateHash(password) : password;
                    COConfigurationManager.setParameter(name, encoded);
                }
                catch (Exception e) {
                    Debug.printStackTrace(e);
                }
            }
        });
    }

    public void setLayoutData(Object layoutData) {
        this.inputField.setLayoutData(layoutData);
    }

    public void setValue(String value) {
        this.inputField.setText(value);
        COConfigurationManager.setParameter(this.name, value);
    }

    public String getValue() {
        return this.inputField.getText();
    }

    public Control getControl() {
        return this.inputField;
    }
}

