/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.exporttorrent.wizard;

import com.aelitis.azureus.core.AzureusCore;
import java.io.File;
import java.io.IOException;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentException;
import org.gudy.azureus2.core3.torrent.TOTorrentFactory;
import org.gudy.azureus2.core3.util.TorrentUtils;
import org.gudy.azureus2.ui.swt.exporttorrent.wizard.ExportTorrentWizardInputPanel;
import org.gudy.azureus2.ui.swt.exporttorrent.wizard.ExportTorrentWizardOutputPanel;
import org.gudy.azureus2.ui.swt.wizard.Wizard;

public class ExportTorrentWizard
extends Wizard {
    String torrent_file = "";
    String export_file = "";

    public ExportTorrentWizard(AzureusCore azureus_core, Display display) {
        super(azureus_core, display, "exportTorrentWizard.title");
        ExportTorrentWizardInputPanel input_panel = new ExportTorrentWizardInputPanel(this, null);
        this.setFirstPanel(input_panel);
    }

    public ExportTorrentWizard(AzureusCore azureus_core, Display display, DownloadManager dm) {
        super(azureus_core, display, "exportTorrentWizard.title");
        this.setTorrentFile(dm.getTorrentFileName());
        ExportTorrentWizardOutputPanel output_panel = new ExportTorrentWizardOutputPanel(this, null);
        this.setFirstPanel(output_panel);
    }

    public void onClose() {
        super.onClose();
    }

    protected void setTorrentFile(String str) {
        this.torrent_file = str;
        this.export_file = String.valueOf(str) + ".xml";
    }

    protected String getTorrentFile() {
        return this.torrent_file;
    }

    protected void setExportFile(String str) {
        this.export_file = str;
    }

    protected String getExportFile() {
        return this.export_file;
    }

    protected boolean performExport() {
        String error_detail;
        String error_title;
        File input_file;
        try {
            input_file = new File(this.getTorrentFile()).getCanonicalFile();
        }
        catch (IOException e) {
            MessageBox mb = new MessageBox(this.getWizardWindow(), 33);
            mb.setText(MessageText.getString("exportTorrentWizard.process.inputfilebad.title"));
            mb.setMessage(String.valueOf(MessageText.getString("exportTorrentWizard.process.inputfilebad.message")) + "\n" + e.toString());
            mb.open();
            return false;
        }
        File output_file = new File(this.export_file);
        if (output_file.exists()) {
            MessageBox mb = new MessageBox(this.getWizardWindow(), 196);
            mb.setText(MessageText.getString("exportTorrentWizard.process.outputfileexists.title"));
            mb.setMessage(MessageText.getString("exportTorrentWizard.process.outputfileexists.message"));
            int result = mb.open();
            if (result == 128) {
                return false;
            }
        }
        try {
            try {
                TOTorrent torrent = TOTorrentFactory.deserialiseFromBEncodedFile(input_file);
                try {
                    torrent.serialiseToXMLFile(output_file);
                    return true;
                }
                catch (TOTorrentException e) {
                    error_title = MessageText.getString("exportTorrentWizard.process.exportfail.title");
                    error_detail = TorrentUtils.exceptionToText(e);
                }
            }
            catch (TOTorrentException e) {
                error_title = MessageText.getString("exportTorrentWizard.process.torrentfail.title");
                error_detail = TorrentUtils.exceptionToText(e);
            }
        }
        catch (Throwable e) {
            error_title = MessageText.getString("exportTorrentWizard.process.unknownfail.title");
            error_detail = e.toString();
        }
        MessageBox mb = new MessageBox(this.getWizardWindow(), 33);
        mb.setText(error_title);
        mb.setMessage(error_detail);
        mb.open();
        return false;
    }
}

