/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.tableitems.mytorrents;

import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.tracker.client.TRTrackerScraperResponse;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;
import org.gudy.azureus2.plugins.ui.tables.TableCellToolTipListener;
import org.gudy.azureus2.ui.swt.views.table.utils.CoreTableColumn;

public class SeedsItem
extends CoreTableColumn
implements TableCellRefreshListener,
TableCellToolTipListener {
    public SeedsItem(String sTableID) {
        super("seeds", 3, -2, 60, sTableID);
        this.setRefreshInterval(-2);
    }

    public void refresh(TableCell cell) {
        long value;
        long lConnectedSeeds = 0L;
        long lTotalSeeds = -1L;
        DownloadManager dm = (DownloadManager)cell.getDataSource();
        if (dm != null) {
            lConnectedSeeds = dm.getNbSeeds();
            TRTrackerScraperResponse hd = dm.getTrackerScrapeResponse();
            if (hd != null && hd.isValid()) {
                lTotalSeeds = hd.getSeeds();
            }
        }
        if (!cell.setSortValue(value = lConnectedSeeds * 10000000L + lTotalSeeds) && cell.isValid()) {
            return;
        }
        String tmp = String.valueOf(lConnectedSeeds);
        if (lTotalSeeds != -1L) {
            tmp = String.valueOf(tmp) + " (" + lTotalSeeds + ")";
        }
        cell.setText(tmp);
    }

    public void cellHover(TableCell cell) {
        long lConnectedSeeds = 0L;
        long lTotalSeeds = -1L;
        DownloadManager dm = (DownloadManager)cell.getDataSource();
        if (dm != null) {
            lConnectedSeeds = dm.getNbSeeds();
            TRTrackerScraperResponse hd = dm.getTrackerScrapeResponse();
            if (hd != null && hd.isValid()) {
                lTotalSeeds = hd.getSeeds();
            }
        }
        String sToolTip = String.valueOf(lConnectedSeeds) + " " + MessageText.getString("GeneralView.label.connected") + "\n";
        if (lTotalSeeds != -1L) {
            sToolTip = String.valueOf(sToolTip) + lTotalSeeds + " " + MessageText.getString("GeneralView.label.in_swarm");
        } else {
            TRTrackerScraperResponse response = dm.getTrackerScrapeResponse();
            sToolTip = String.valueOf(sToolTip) + "?? " + MessageText.getString("GeneralView.label.in_swarm");
            if (response != null) {
                sToolTip = String.valueOf(sToolTip) + "(" + response.getStatusString() + ")";
            }
        }
        cell.setToolTip(sToolTip);
    }

    public void cellHoverComplete(TableCell cell) {
        cell.setToolTip(null);
    }
}

