/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.webplugin.remoteui.xml.server;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.gudy.azureus2.plugins.PluginException;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.tracker.web.TrackerWebPageRequest;
import org.gudy.azureus2.plugins.tracker.web.TrackerWebPageResponse;
import org.gudy.azureus2.plugins.ui.model.BasicPluginConfigModel;
import org.gudy.azureus2.pluginsimpl.remote.RPRequestAccessController;
import org.gudy.azureus2.pluginsimpl.remote.RPRequestHandler;
import org.gudy.azureus2.ui.webplugin.WebPlugin;
import org.gudy.azureus2.ui.webplugin.WebPluginAccessController;
import org.gudy.azureus2.ui.webplugin.remoteui.xml.server.XMLRequestProcessor;

public class XMLHTTPServerPlugin
extends WebPlugin {
    public static final int DEFAULT_PORT = 6884;
    protected static Properties defaults = new Properties();
    protected RPRequestHandler request_handler;
    protected RPRequestAccessController access_controller;

    static {
        defaults.put("Port", new Integer(6884));
    }

    public XMLHTTPServerPlugin() {
        super(defaults);
    }

    public void initialize(PluginInterface _plugin_interface) throws PluginException {
        super.initialize(_plugin_interface);
        BasicPluginConfigModel config = this.getConfigModel();
        this.request_handler = new RPRequestHandler(_plugin_interface);
        this.access_controller = new WebPluginAccessController(_plugin_interface);
    }

    public boolean generateSupport(TrackerWebPageRequest request2, TrackerWebPageResponse response) throws IOException {
        String url = request2.getURL().toLowerCase();
        if (url.equals("process.cgi") || url.equals("/process.cgi")) {
            InputStream is = null;
            try {
                response.setContentType("text/xml; charset=\"utf-8\"");
                new XMLRequestProcessor(this.request_handler, this.access_controller, request2.getClientAddress(), request2.getInputStream(), response.getOutputStream());
                if (is != null) {
                    is.close();
                }
                return true;
            }
            catch (Throwable throwable) {
                if (is != null) {
                    is.close();
                }
                throw throwable;
            }
        }
        return false;
    }
}

