/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.gtk.GdkColor;
import org.eclipse.swt.internal.gtk.GdkRectangle;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.ImageList;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Tree;

public class TreeItem
extends Item {
    Tree parent;
    static final int EXPANDER_EXTRA_PADDING = 4;

    public TreeItem(Tree parent, int style) {
        super(parent, style);
        this.parent = parent;
        parent.createItem(this, 0, -1);
    }

    public TreeItem(Tree parent, int style, int index) {
        super(parent, style);
        if (index < 0) {
            this.error(6);
        }
        this.parent = parent;
        parent.createItem(this, 0, index);
    }

    public TreeItem(TreeItem parentItem, int style) {
        super(TreeItem.checkNull((TreeItem)parentItem).parent, style);
        this.parent = parentItem.parent;
        this.parent.createItem(this, parentItem.handle, -1);
    }

    public TreeItem(TreeItem parentItem, int style, int index) {
        super(TreeItem.checkNull((TreeItem)parentItem).parent, style);
        if (index < 0) {
            this.error(14);
        }
        this.parent = parentItem.parent;
        this.parent.createItem(this, parentItem.handle, index);
    }

    static TreeItem checkNull(TreeItem item) {
        if (item == null) {
            SWT.error(4);
        }
        return item;
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    public Color getBackground() {
        this.checkWidget();
        int[] ptr = new int[1];
        OS.gtk_tree_model_get((int)this.parent.modelHandle, (int)this.handle, (int)3, (int[])ptr, (int)-1);
        if (ptr[0] == 0) {
            return this.parent.getBackground();
        }
        GdkColor gdkColor = new GdkColor();
        OS.memmove((GdkColor)gdkColor, (int)ptr[0], (int)GdkColor.sizeof);
        return Color.gtk_new(this.display, gdkColor);
    }

    public Rectangle getBounds() {
        this.checkWidget();
        int parentHandle = this.parent.handle;
        GdkRectangle rect = new GdkRectangle();
        int column = OS.gtk_tree_view_get_column((int)parentHandle, (int)0);
        int path = OS.gtk_tree_model_get_path((int)this.parent.modelHandle, (int)this.handle);
        OS.gtk_widget_realize((int)parentHandle);
        OS.gtk_tree_view_get_cell_area((int)parentHandle, (int)path, (int)column, (GdkRectangle)rect);
        boolean isExpander = OS.gtk_tree_model_iter_n_children((int)this.parent.modelHandle, (int)this.handle) > 0;
        boolean isExpanded = OS.gtk_tree_view_row_expanded((int)parentHandle, (int)path);
        OS.gtk_tree_view_column_cell_set_cell_data((int)column, (int)this.parent.modelHandle, (int)this.handle, (boolean)isExpander, (boolean)isExpanded);
        int[] x = new int[1];
        int[] width = new int[1];
        OS.gtk_cell_renderer_get_size((int)this.parent.textRenderer, (int)parentHandle, null, null, null, (int[])width, null);
        rect.width = width[0];
        int[] buffer = new int[1];
        if (OS.gtk_tree_view_get_expander_column((int)parentHandle) == column) {
            OS.gtk_widget_style_get((int)parentHandle, (byte[])OS.expander_size, (int[])buffer, (int)0);
            rect.x += buffer[0] + 4;
        }
        OS.gtk_widget_style_get((int)parentHandle, (byte[])OS.horizontal_separator, (int[])buffer, (int)0);
        int horizontalSeparator = buffer[0];
        rect.x += horizontalSeparator;
        if (OS.gtk_major_version() * 100 + OS.gtk_minor_version() * 10 + OS.gtk_micro_version() >= 213) {
            OS.gtk_tree_view_column_cell_get_position((int)column, (int)this.parent.textRenderer, (int[])x, null);
            rect.x += x[0];
        } else {
            if ((this.parent.style & 0x20) != 0) {
                OS.gtk_cell_renderer_get_size((int)this.parent.checkRenderer, (int)parentHandle, null, null, null, (int[])width, null);
                rect.x += width[0] + horizontalSeparator;
            }
            OS.gtk_cell_renderer_get_size((int)this.parent.pixbufRenderer, (int)parentHandle, null, null, null, (int[])width, null);
            rect.x += width[0] + horizontalSeparator;
        }
        int border = this.parent.getBorderWidth();
        rect.x += border;
        rect.y += border;
        OS.gtk_tree_path_free((int)path);
        int[] wx = new int[1];
        OS.gtk_tree_view_tree_to_widget_coords((int)parentHandle, (int)rect.x, (int)0, (int[])wx, null);
        rect.x = wx[0];
        return new Rectangle(rect.x, rect.y, rect.width, rect.height);
    }

    public boolean getChecked() {
        this.checkWidget();
        if ((this.parent.style & 0x20) == 0) {
            return false;
        }
        int[] ptr = new int[1];
        OS.gtk_tree_model_get((int)this.parent.modelHandle, (int)this.handle, (int)6, (int[])ptr, (int)-1);
        return ptr[0] != 0;
    }

    public boolean getExpanded() {
        this.checkWidget();
        int path = OS.gtk_tree_model_get_path((int)this.parent.modelHandle, (int)this.handle);
        boolean answer = OS.gtk_tree_view_row_expanded((int)this.parent.handle, (int)path);
        OS.gtk_tree_path_free((int)path);
        return answer;
    }

    public Font getFont() {
        this.checkWidget();
        int[] ptr = new int[1];
        OS.gtk_tree_model_get((int)this.parent.modelHandle, (int)this.handle, (int)4, (int[])ptr, (int)-1);
        if (ptr[0] == 0) {
            return this.parent.getFont();
        }
        return Font.gtk_new(this.display, ptr[0]);
    }

    public Color getForeground() {
        this.checkWidget();
        int[] ptr = new int[1];
        OS.gtk_tree_model_get((int)this.parent.modelHandle, (int)this.handle, (int)2, (int[])ptr, (int)-1);
        if (ptr[0] == 0) {
            return this.parent.getForeground();
        }
        GdkColor gdkColor = new GdkColor();
        OS.memmove((GdkColor)gdkColor, (int)ptr[0], (int)GdkColor.sizeof);
        return Color.gtk_new(this.display, gdkColor);
    }

    public boolean getGrayed() {
        this.checkWidget();
        if ((this.parent.style & 0x20) == 0) {
            return false;
        }
        int[] ptr = new int[1];
        OS.gtk_tree_model_get((int)this.parent.modelHandle, (int)this.handle, (int)7, (int[])ptr, (int)-1);
        return ptr[0] != 0;
    }

    public int getItemCount() {
        this.checkWidget();
        return OS.gtk_tree_model_iter_n_children((int)this.parent.modelHandle, (int)this.handle);
    }

    public TreeItem[] getItems() {
        this.checkWidget();
        return this.parent.getItems(this.handle);
    }

    public Tree getParent() {
        this.checkWidget();
        return this.parent;
    }

    public TreeItem getParentItem() {
        this.checkWidget();
        int path = OS.gtk_tree_model_get_path((int)this.parent.modelHandle, (int)this.handle);
        TreeItem item = null;
        if (OS.gtk_tree_path_get_depth((int)path) > 1) {
            OS.gtk_tree_path_up((int)path);
            int iter = OS.g_malloc((int)OS.GtkTreeIter_sizeof());
            if (OS.gtk_tree_model_get_iter((int)this.parent.modelHandle, (int)iter, (int)path)) {
                int[] index = new int[1];
                OS.gtk_tree_model_get((int)this.parent.modelHandle, (int)iter, (int)5, (int[])index, (int)-1);
                item = this.parent.items[index[0]];
            }
            OS.g_free((int)iter);
        }
        OS.gtk_tree_path_free((int)path);
        return item;
    }

    void releaseChild() {
        super.releaseChild();
        this.parent.destroyItem(this);
    }

    void releaseWidget() {
        super.releaseWidget();
        if (this.handle != 0) {
            OS.g_free((int)this.handle);
        }
        this.handle = 0;
        this.parent = null;
    }

    public void setBackground(Color color) {
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            SWT.error(5);
        }
        GdkColor gdkColor = color != null ? color.handle : null;
        OS.gtk_tree_store_set((int)this.parent.modelHandle, (int)this.handle, (int)3, (GdkColor)gdkColor, (int)-1);
    }

    public void setChecked(boolean checked) {
        this.checkWidget();
        if ((this.parent.style & 0x20) == 0) {
            return;
        }
        OS.gtk_tree_store_set((int)this.parent.modelHandle, (int)this.handle, (int)6, (boolean)checked, (int)-1);
    }

    public void setGrayed(boolean grayed) {
        this.checkWidget();
        if ((this.parent.style & 0x20) == 0) {
            return;
        }
        OS.gtk_tree_store_set((int)this.parent.modelHandle, (int)this.handle, (int)7, (boolean)grayed, (int)-1);
    }

    public void setExpanded(boolean expanded) {
        this.checkWidget();
        int path = OS.gtk_tree_model_get_path((int)this.parent.modelHandle, (int)this.handle);
        if (expanded) {
            OS.g_signal_handlers_block_matched((int)this.parent.handle, (int)16, (int)0, (int)0, (int)0, (int)0, (int)40);
            OS.gtk_tree_view_expand_row((int)this.parent.handle, (int)path, (boolean)false);
            OS.g_signal_handlers_unblock_matched((int)this.parent.handle, (int)16, (int)0, (int)0, (int)0, (int)0, (int)40);
        } else {
            OS.g_signal_handlers_block_matched((int)this.parent.handle, (int)16, (int)0, (int)0, (int)0, (int)0, (int)39);
            OS.gtk_widget_realize((int)this.parent.handle);
            OS.gtk_tree_view_collapse_row((int)this.parent.handle, (int)path);
            OS.g_signal_handlers_unblock_matched((int)this.parent.handle, (int)16, (int)0, (int)0, (int)0, (int)0, (int)39);
        }
        OS.gtk_tree_path_free((int)path);
    }

    public void setFont(Font font) {
        this.checkWidget();
        if (font != null && font.isDisposed()) {
            SWT.error(5);
        }
        int fontHandle = font != null ? font.handle : 0;
        OS.gtk_tree_store_set((int)this.parent.modelHandle, (int)this.handle, (int)4, (int)fontHandle, (int)-1);
    }

    public void setForeground(Color color) {
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            SWT.error(5);
        }
        GdkColor gdkColor = color != null ? color.handle : null;
        OS.gtk_tree_store_set((int)this.parent.modelHandle, (int)this.handle, (int)2, (GdkColor)gdkColor, (int)-1);
    }

    public void setImage(Image image) {
        this.checkWidget();
        if (image != null && image.isDisposed()) {
            this.error(5);
        }
        super.setImage(image);
        int pixbuf = 0;
        if (image != null) {
            int imageIndex;
            ImageList imageList = this.parent.imageList;
            if (imageList == null) {
                imageList = this.parent.imageList = new ImageList();
            }
            if ((imageIndex = imageList.indexOf(image)) == -1) {
                imageIndex = imageList.add(image);
            }
            pixbuf = imageList.getPixbuf(imageIndex);
        }
        OS.gtk_tree_store_set((int)this.parent.modelHandle, (int)this.handle, (int)1, (int)pixbuf, (int)-1);
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        super.setText(string);
        byte[] buffer = Converter.wcsToMbcs(null, string, true);
        OS.gtk_tree_store_set((int)this.parent.modelHandle, (int)this.handle, (int)0, (byte[])buffer, (int)-1);
    }
}

