/*
 * File:          ExceptionTest_IOR.h
 * Symbol:        ExceptionTest-v1.0
 * Symbol Type:   package
 * Babel Version: 0.10.2
 * Description:   Intermediate Object Representation for ExceptionTest
 * 
 * WARNING: Automatically generated; changes will be lost
 * 
 * babel-version = 0.10.2
 */

#ifndef included_ExceptionTest_IOR_h
#define included_ExceptionTest_IOR_h

/*
 * Symbol "ExceptionTest" (version 1.0)
 * 
 * <p>
 * Package <code>ExceptionTest</code> tests the exception capabilites of the
 * sidl run-time system.  The test case is Fibanocci number generation in which
 * exceptions may be thrown if the input parameter is negative, the Fibanocci
 * number exceeds a specified maximum, or if the Fibanocci recursion exceeds
 * a specified depth.  Three different exceptions may be thrown:
 * </p>
 * <ul>
 * <li>a <code>NegativeValueException</code> if the input is negative</li>
 * <li>a <code>TooDeepException</code> if the recursion depth is exceeded</li>
 * <li>a <code>TooBigException</code> if the maximum value is exceeded</li>
 * </ul>
 * <p>
 * Just to make things interesting, the <code>TooDeepException</code> and the
 * <code>TooBigException</code> extend a common <code>FibException</code>.
 * This derivation allows us to test the exception casting support in the
 * run-time.
 * </p>
 */

#ifndef included_ExceptionTest_Fib_IOR_h
#include "ExceptionTest_Fib_IOR.h"
#endif
#ifndef included_ExceptionTest_FibException_IOR_h
#include "ExceptionTest_FibException_IOR.h"
#endif
#ifndef included_ExceptionTest_NegativeValueException_IOR_h
#include "ExceptionTest_NegativeValueException_IOR.h"
#endif
#ifndef included_ExceptionTest_TooBigException_IOR_h
#include "ExceptionTest_TooBigException_IOR.h"
#endif
#ifndef included_ExceptionTest_TooDeepException_IOR_h
#include "ExceptionTest_TooDeepException_IOR.h"
#endif

#endif
