/*
 * File:          synch_RegOut_Impl.c
 * Symbol:        synch.RegOut-v0.1
 * Symbol Type:   class
 * Babel Version: 0.10.2
 * Description:   Server-side implementation for synch.RegOut
 * 
 * WARNING: Automatically generated; only changes within splicers preserved
 * 
 * babel-version = 0.10.2
 */

/*
 * DEVELOPERS ARE EXPECTED TO PROVIDE IMPLEMENTATIONS
 * FOR THE FOLLOWING METHODS BETWEEN SPLICER PAIRS.
 */

/*
 * Symbol "synch.RegOut" (version 0.1)
 * 
 * Regression test output class. 
 */

#include "synch_RegOut_Impl.h"

#line 26 "../../../../babel/regression/output/libC/synch_RegOut_Impl.c"
/* DO-NOT-DELETE splicer.begin(synch.RegOut._includes) */
#include <stdlib.h>
#include <stdio.h>

#define CTORSTATE   0
#define TALLYING    1
#define CLOSED      2

static const char * const s_result_strings[] = {
  "PASS",
  "FAIL",
  "XFAIL",
  "XPASS"
};

static void beginTallying(struct synch_RegOut__data *private)
{
  private->state = TALLYING;
  private->current_part = 1;
  printf("NPARTS %d\n", private->expected_parts);
  fflush(stdout);
}


int calculateResult(struct synch_RegOut__data *private) {
  if ((private->num_fails != 0) ||
      (private->num_xpass != 0) ||
      ((private->expected_parts >= 0) &&
       ((private->num_passes + private->num_xfails) !=
        private->expected_parts)))
    return synch_ResultType_FAIL;
  if (private->num_xfails > 0) return synch_ResultType_XFAIL;
  return synch_ResultType_PASS;
}
    
/* DO-NOT-DELETE splicer.end(synch.RegOut._includes) */
#line 63 "synch_RegOut_Impl.c"

/*
 * Static class initializer called exactly once before any user-defined method is dispatched
 */

#undef __FUNC__
#define __FUNC__ "impl_synch_RegOut__load"

void
impl_synch_RegOut__load(
  void)
{
#line 74 "../../../../babel/regression/output/libC/synch_RegOut_Impl.c"
  /* DO-NOT-DELETE splicer.begin(synch.RegOut._load) */
  /* Insert the implementation of the static class initializer method here... */
  /* DO-NOT-DELETE splicer.end(synch.RegOut._load) */
#line 80 "synch_RegOut_Impl.c"
}
/*
 * Class constructor called when the class is created.
 */

#undef __FUNC__
#define __FUNC__ "impl_synch_RegOut__ctor"

void
impl_synch_RegOut__ctor(
  /* in */ synch_RegOut self)
{
#line 89 "../../../../babel/regression/output/libC/synch_RegOut_Impl.c"
  /* DO-NOT-DELETE splicer.begin(synch.RegOut._ctor) */
  struct synch_RegOut__data *private = 
    malloc(sizeof(struct synch_RegOut__data));
  synch_RegOut__set_data(self, private);
  private->expected_parts = -1;
  private->current_part = 0;
  private->num_passes = 0;
  private->num_xfails = 0;
  private->num_xpass = 0;
  private->num_fails = 0;
  private->state = CTORSTATE;
  /* DO-NOT-DELETE splicer.end(synch.RegOut._ctor) */
#line 106 "synch_RegOut_Impl.c"
}

/*
 * Class destructor called when the class is deleted.
 */

#undef __FUNC__
#define __FUNC__ "impl_synch_RegOut__dtor"

void
impl_synch_RegOut__dtor(
  /* in */ synch_RegOut self)
{
#line 114 "../../../../babel/regression/output/libC/synch_RegOut_Impl.c"
  /* DO-NOT-DELETE splicer.begin(synch.RegOut._dtor) */
  struct synch_RegOut__data *private =
    synch_RegOut__get_data(self);
  if (private->state < CLOSED) synch_RegOut_close(self);
  free((void *)private);
  synch_RegOut__set_data(self, NULL);
  /* DO-NOT-DELETE splicer.end(synch.RegOut._dtor) */
#line 128 "synch_RegOut_Impl.c"
}

/*
 * In some circumstances, it is necessary to use the
 * singleton pattern.
 */

#undef __FUNC__
#define __FUNC__ "impl_synch_RegOut_getInstance"

synch_RegOut
impl_synch_RegOut_getInstance(
  void)
{
#line 135 "../../../../babel/regression/output/libC/synch_RegOut_Impl.c"
  /* DO-NOT-DELETE splicer.begin(synch.RegOut.getInstance) */
  static synch_RegOut result = NULL;
  if (result == NULL) {
    result = synch_RegOut__create();
  }
  synch_RegOut_addRef(result);
  return result;
  /* DO-NOT-DELETE splicer.end(synch.RegOut.getInstance) */
#line 152 "synch_RegOut_Impl.c"
}

/*
 * Tell this class how many parts to expect.
 * Calling this method twice or after any of the other
 * methods in this class causes it to execute
 * forceFailure.
 * @param numparts  a negative number indicates the number
 *                  of parts is unknown
 */

#undef __FUNC__
#define __FUNC__ "impl_synch_RegOut_setExpectations"

void
impl_synch_RegOut_setExpectations(
  /* in */ synch_RegOut self,
  /* in */ int32_t numparts)
{
#line 162 "../../../../babel/regression/output/libC/synch_RegOut_Impl.c"
  /* DO-NOT-DELETE splicer.begin(synch.RegOut.setExpectations) */
  struct synch_RegOut__data *private =
    synch_RegOut__get_data(self);
  if (private->state == CTORSTATE) {
    private->expected_parts = numparts;
    beginTallying(private);
  }
  else {
    synch_RegOut_forceFailure(self);
  }
  /* DO-NOT-DELETE splicer.end(synch.RegOut.setExpectations) */
#line 184 "synch_RegOut_Impl.c"
}

/*
 * Return the current part number.
 */

#undef __FUNC__
#define __FUNC__ "impl_synch_RegOut_getCurrentPart"

int32_t
impl_synch_RegOut_getCurrentPart(
  /* in */ synch_RegOut self)
{
#line 186 "../../../../babel/regression/output/libC/synch_RegOut_Impl.c"
  /* DO-NOT-DELETE splicer.begin(synch.RegOut.getCurrentPart) */
  struct synch_RegOut__data *private =
    synch_RegOut__get_data(self);
  if (private->state < TALLYING) {
    beginTallying(private);
  }
  if (private->state == TALLYING) return private->current_part;
  return -1;
  /* DO-NOT-DELETE splicer.end(synch.RegOut.getCurrentPart) */
#line 208 "synch_RegOut_Impl.c"
}

/*
 * Print the start part line.
 */

#undef __FUNC__
#define __FUNC__ "impl_synch_RegOut_startPart"

void
impl_synch_RegOut_startPart(
  /* in */ synch_RegOut self,
  /* in */ int32_t part)
{
#line 209 "../../../../babel/regression/output/libC/synch_RegOut_Impl.c"
  /* DO-NOT-DELETE splicer.begin(synch.RegOut.startPart) */
  struct synch_RegOut__data *private =
    synch_RegOut__get_data(self);
  if (private->state < TALLYING) {
    beginTallying(private);
  }
  if ((private->state == TALLYING) && (part == private->current_part)) {
    printf("PART %d\n", part);
    fflush(stdout);
  }
  else {
    synch_RegOut_forceFailure(self);
  }
  /* DO-NOT-DELETE splicer.end(synch.RegOut.startPart) */
#line 238 "synch_RegOut_Impl.c"
}

/*
 * Print the end part line.
 */

#undef __FUNC__
#define __FUNC__ "impl_synch_RegOut_endPart"

void
impl_synch_RegOut_endPart(
  /* in */ synch_RegOut self,
  /* in */ int32_t part,
  /* in */ enum synch_ResultType__enum res)
{
#line 238 "../../../../babel/regression/output/libC/synch_RegOut_Impl.c"
  /* DO-NOT-DELETE splicer.begin(synch.RegOut.endPart) */
  struct synch_RegOut__data *private =
    synch_RegOut__get_data(self);
  if ((private->state == TALLYING) && (private->current_part == part)) {
    if ((res < 0) || (res > sizeof(s_result_strings)/sizeof(sizeof(char *)))) {
      res = synch_ResultType_FAIL;
    }
    printf("RESULT %d %s\n", part, s_result_strings[res]);
    fflush(stdout);
    switch(res) {
    case synch_ResultType_PASS:
      ++(private->num_passes);
      break;
    case synch_ResultType_FAIL:
      ++(private->num_fails);
      break;
    case synch_ResultType_XFAIL:
      ++(private->num_xfails);
      break;
    case synch_ResultType_XPASS:
      ++(private->num_xpass);
      break;
    }
    ++(private->current_part);
  }
  else {
    synch_RegOut_forceFailure(self);
  }
  /* DO-NOT-DELETE splicer.end(synch.RegOut.endPart) */
#line 284 "synch_RegOut_Impl.c"
}

/*
 * Print COMMENT: <comment>\n.
 */

#undef __FUNC__
#define __FUNC__ "impl_synch_RegOut_writeComment"

void
impl_synch_RegOut_writeComment(
  /* in */ synch_RegOut self,
  /* in */ const char* comment)
{
#line 281 "../../../../babel/regression/output/libC/synch_RegOut_Impl.c"
  /* DO-NOT-DELETE splicer.begin(synch.RegOut.writeComment) */
  printf("COMMENT: %s\n", comment);
  /* DO-NOT-DELETE splicer.end(synch.RegOut.writeComment) */
#line 303 "synch_RegOut_Impl.c"
}

/*
 * Unconditionally fail right now.
 */

#undef __FUNC__
#define __FUNC__ "impl_synch_RegOut_forceFailure"

void
impl_synch_RegOut_forceFailure(
  /* in */ synch_RegOut self)
{
#line 297 "../../../../babel/regression/output/libC/synch_RegOut_Impl.c"
  /* DO-NOT-DELETE splicer.begin(synch.RegOut.forceFailure) */
  struct synch_RegOut__data *private =
    synch_RegOut__get_data(self);
  switch(private->state) {
  case CTORSTATE:
    beginTallying(private); /* fall through to next case intended */
  case TALLYING:
    private->num_fails = 1;
    synch_RegOut_close(self);
  case CLOSED:
    break;
  }
  /* DO-NOT-DELETE splicer.end(synch.RegOut.forceFailure) */
#line 331 "synch_RegOut_Impl.c"
}

/*
 * Finish the test. This is called by the destructor if you
 * forget.
 */

#undef __FUNC__
#define __FUNC__ "impl_synch_RegOut_close"

void
impl_synch_RegOut_close(
  /* in */ synch_RegOut self)
{
#line 324 "../../../../babel/regression/output/libC/synch_RegOut_Impl.c"
  /* DO-NOT-DELETE splicer.begin(synch.RegOut.close) */
  struct synch_RegOut__data *private =
    synch_RegOut__get_data(self);
  if (private->state == TALLYING) {
    int result = calculateResult(private);
    
    printf("TEST_RESULT %s\n", s_result_strings[result]);
    fflush(stdout);
  }
  private->state = CLOSED;
  /* DO-NOT-DELETE splicer.end(synch.RegOut.close) */
#line 358 "synch_RegOut_Impl.c"
}
