/*
 * File:        sorttest.c
 * Copyright:   (c) 2002 The Regents of the University of California
 * Revision:    @(#) $Revision: 4434 $
 * Date:        $Date: 2005-03-17 09:05:29 -0800 (Thu, 17 Mar 2005) $
 * Description: Simple C driver for the sort regression test
 *
 */

#include <stdlib.h>
#include <stdio.h>
#include <time.h>
#include "sort_SortTest.h"
#include "sort_MergeSort.h"
#include "sort_QuickSort.h"
#include "sort_HeapSort.h"
#include "sort_SortingAlgorithm.h"
#include "synch.h"

/**
 * Fill the stack with random junk.
 */
int clearstack(int magicNumber) {
  int chunk[2048], i;
  for(i = 0; i < 2048; i++){
    chunk[i] = rand() + magicNumber;
  }
  for(i = 0; i < 16; i++){
    magicNumber += chunk[rand() & 2047];
  }
  return magicNumber;
}

#define MYASSERT( AAA ) \
  declare_part(tracker,  &part_no ); \
  magicNumber = clearstack(magicNumber); \
  synch_RegOut_writeComment(tracker, #AAA); \
  if ( AAA ) result = synch_ResultType_PASS; \
  else result = synch_ResultType_FAIL;  \
  end_part( tracker, part_no, result);

void declare_part(synch_RegOut tracker,  int * part_no ) {
  synch_RegOut_startPart(tracker, ++(*part_no));
}

void end_part( synch_RegOut tracker, int part_no,
               enum synch_ResultType__enum result) {
  synch_RegOut_endPart(tracker, part_no, result);
}

int
main(int argc, char **argv)
{
  enum synch_ResultType__enum result = synch_ResultType_PASS;
  synch_RegOut tracker = synch_RegOut_getInstance();
  int magicNumber = 1;
  int part_no = 0;
  sort_MergeSort merge = sort_MergeSort__create();
  sort_QuickSort quick = sort_QuickSort__create();
  sort_HeapSort  heap = sort_HeapSort__create();
  struct sort_SortingAlgorithm__array* 
    algs = sort_SortingAlgorithm__array_create1d(3);
  srandom(time(NULL));
  synch_RegOut_setExpectations(tracker, 4);
  MYASSERT(merge != NULL);
  MYASSERT(quick != NULL);
  MYASSERT(heap != NULL);
  sort_SortingAlgorithm__array_set1
    (algs, 0, sort_SortingAlgorithm__cast(merge));
  sort_SortingAlgorithm__array_set1
    (algs, 1, sort_SortingAlgorithm__cast(quick));
  sort_SortingAlgorithm__array_set1
    (algs, 2, sort_SortingAlgorithm__cast(heap));
  /* remove extraneous references */
  sort_MergeSort_deleteRef(merge); merge = NULL;
  sort_QuickSort_deleteRef(quick); quick = NULL;
  sort_HeapSort_deleteRef(heap); heap = NULL;
  /* call test */
  MYASSERT(sort_SortTest_stressTest(algs) == TRUE);
  sort_SortingAlgorithm__array_deleteRef(algs);
  synch_RegOut_close(tracker);
  synch_RegOut_deleteRef(tracker);
  return 0;
}
