#ifndef DEFAULTS_H
#define DEFAULTS_H

#include "config.h"


#define FILENAME_LENGTH		500
// TODO conflicts
#define MAX_WORD_LEN_2		70
#define MAX_WORDS_ALLOWED_2	7

// Configuration file
static const char REGISTRY_FILE[]               = ".cbedic";
static const char REGISTRY_FILE_SUFFIX[]        = "~";
static const char ENV_HOME[]                    = "HOME";

// Strings in configuration file
static const char OPTION_ENG_BUL_DAT[]          = "EngBulDat";
static const char OPTION_BUL_ENG_DAT[]          = "BulEngDat";
static const char OPTION_SEPARATE_MEANINGS[]    = "SeparatedMeanings";
static const char OPTION_LATIN_OUTPUT[]         = "LatinOutput";
static const char OPTION_LATIN_INPUT[]          = "LatinInput";
static const char OPTION_HTML_OUTPUT[]          = "HTMLOutput";
static const char OPTION_EXACT_MATCH[]          = "ExactMatch";
static const char OPTION_START_INTERACTIVE[]    = "StartInteractive";

// Default values
static const bool DEFAULT_SEPARATE_MEANINGS     = false;
static const bool DEFAULT_LATIN_OUTPUT          = false;
static const bool DEFAULT_LATIN_INPUT           = false;
static const bool DEFAULT_HTML_OUTPUT           = false;
static const bool DEFAULT_EXACT_MATCH           = false;
static const bool DEFAULT_START_INTERACTIVE	= false;

#ifdef ENG_BUL_DAT_CONFIG
static const char ENG_BUL_DAT[]		= ENG_BUL_DAT_CONFIG;
#else
static const char ENG_BUL_DAT[]         = "/usr/local/share/engbul.dat";
#endif

#ifdef BUL_ENG_DAT_CONFIG
static const char BUL_ENG_DAT[]		= BUL_ENG_DAT_CONFIG;
#else
static const char BUL_ENG_DAT[]		= "/usr/local/share/buleng.dat";
#endif

#endif
