/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Touch;

public class Expand
extends Task {
    private String dest;
    private String source;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void execute() throws BuildException {
        if ("expand".equals(this.taskType)) {
            this.log("!! expand is deprecated. Use unzip instead. !!");
        }
        Touch touch = (Touch)this.project.createTask("touch");
        touch.setOwningTarget(this.target);
        File srcF = this.project.resolveFile(this.source);
        File dir = this.project.resolveFile(this.dest);
        ZipInputStream zis = null;
        try {
            try {
                this.log("Expanding: " + srcF + " into " + dir, 2);
                zis = new ZipInputStream(new FileInputStream(srcF));
                ZipEntry ze = null;
                while ((ze = zis.getNextEntry()) != null) {
                    File f = new File(dir, Project.translatePath(ze.getName()));
                    try {
                        this.log("expand-file " + ze.getName(), 3);
                        File dirF = new File(f.getParent());
                        dirF.mkdirs();
                        if (ze.isDirectory()) {
                            f.mkdirs();
                        } else {
                            byte[] buffer = new byte[1024];
                            int length = 0;
                            FileOutputStream fos = new FileOutputStream(f);
                            while ((length = zis.read(buffer)) >= 0) {
                                fos.write(buffer, 0, length);
                            }
                            fos.close();
                        }
                        if (Project.getJavaVersion() == "1.1") continue;
                        touch.setFile(f.getAbsolutePath());
                        touch.setMillis(ze.getTime());
                        touch.touch();
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        this.log("Unable to expand to file " + f.getPath(), 1);
                    }
                }
                this.log("expand complete", 3);
            }
            catch (IOException ioe) {
                throw new BuildException("Error while expanding " + srcF.getPath(), ioe);
            }
            Object var6_12 = null;
            if (zis == null) return;
        }
        catch (Throwable throwable) {
            Object var6_13 = null;
            if (zis == null) throw throwable;
            try {
                zis.close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            zis.close();
            return;
        }
        catch (IOException iOException) {}
    }

    public void setDest(String d) {
        this.dest = d;
    }

    public void setSrc(String s) {
        this.source = s;
    }
}

