/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.util.db.map;

import org.apache.turbine.util.db.map.TableMap;

public class ColumnMap {
    private Object type = null;
    private int size = 0;
    private boolean pk = false;
    private boolean notNull = false;
    private String relatedTableName = "";
    private String relatedColumnName = "";
    private TableMap table;
    private String columnName;

    public ColumnMap(String name, TableMap containingTable) {
        this.columnName = name;
        this.table = containingTable;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public String getFullyQualifiedName() {
        return String.valueOf(this.table.getName()) + "." + this.columnName;
    }

    public String getRelatedColumnName() {
        return this.relatedColumnName;
    }

    public String getRelatedName() {
        return String.valueOf(this.relatedTableName) + "." + this.relatedColumnName;
    }

    public String getRelatedTableName() {
        return this.relatedTableName;
    }

    public int getSize() {
        return this.size;
    }

    public String getTableName() {
        return this.table.getName();
    }

    public Object getType() {
        return this.type;
    }

    public boolean isForeignKey() {
        return this.relatedTableName != null && this.relatedTableName.length() > 0;
    }

    public boolean isNotNull() {
        return this.notNull || this.isPrimaryKey();
    }

    public boolean isPrimaryKey() {
        return this.pk;
    }

    public void setForeignKey(String fullyQualifiedName) {
        if (fullyQualifiedName != null && fullyQualifiedName.length() > 0) {
            this.relatedTableName = fullyQualifiedName.substring(0, fullyQualifiedName.indexOf(46));
            this.relatedColumnName = fullyQualifiedName.substring(fullyQualifiedName.indexOf(46) + 1);
        } else {
            this.relatedTableName = "";
            this.relatedColumnName = "";
        }
    }

    public void setForeignKey(String tableName, String columnName) {
        if (tableName != null && tableName.length() > 0 && columnName != null && columnName.length() > 0) {
            this.relatedTableName = tableName;
            this.relatedColumnName = columnName;
        } else {
            this.relatedTableName = "";
            this.relatedColumnName = "";
        }
    }

    public void setNotNull(boolean nn) {
        this.notNull = nn;
    }

    public void setPrimaryKey(boolean pk) {
        this.pk = pk;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public void setType(Object type) {
        this.type = type;
    }
}

