/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.sql.SQLException;
import org.hsqldb.Column;
import org.hsqldb.Node;
import org.hsqldb.Table;
import org.hsqldb.Trace;

class Row {
    private Object[] oData;
    private Table tTable;
    static int iCurrentAccess = 0;
    int iLastAccess;
    Row rLast;
    Row rNext;
    int iPos;
    int iSize;
    boolean bChanged;
    private Node nFirstIndex;

    Row(Table table, DataInput dataInput, int n, Row row) throws IOException, SQLException {
        this.tTable = table;
        int n2 = this.tTable.getIndexCount();
        this.iPos = n;
        Node node = this.nFirstIndex = new Node(this, dataInput, 0);
        int n3 = 1;
        while (n3 < n2) {
            node = node.nNext = new Node(this, dataInput, n3);
            ++n3;
        }
        int n4 = this.tTable.getInternalColumnCount();
        this.oData = Column.readData(dataInput, n4);
        Trace.check(dataInput.readInt() == this.iPos, 32);
        this.insert(row);
        this.iLastAccess = iCurrentAccess++;
    }

    Row(Table table, Object[] objectArray) throws SQLException {
        this.tTable = table;
        int n = this.tTable.getIndexCount();
        Node node = this.nFirstIndex = new Node(this, 0);
        int n2 = 1;
        while (n2 < n) {
            node = node.nNext = new Node(this, n2);
            ++n2;
        }
        this.oData = objectArray;
        if (this.tTable != null && this.tTable.cCache != null) {
            this.iLastAccess = iCurrentAccess++;
            this.iSize = 8 + Column.getSize(objectArray, this.tTable) + 32 * this.tTable.getIndexCount();
            this.iSize = (this.iSize + 7) / 8 * 8;
            this.tTable.cCache.add(this);
        }
        this.bChanged = true;
    }

    boolean canRemove() throws SQLException {
        Node node = this.nFirstIndex;
        while (node != null) {
            if (node.iParent == 0 && node.nParent == null) {
                return true;
            }
            node = node.nNext;
        }
        return false;
    }

    void changed() {
        this.bChanged = true;
        this.iLastAccess = iCurrentAccess++;
    }

    void cleanUpCache() throws SQLException {
        if (this.tTable != null && this.tTable.cCache != null) {
            this.iLastAccess = iCurrentAccess++;
            this.tTable.cCache.cleanUp();
        }
    }

    void delete() throws SQLException {
        if (this.tTable != null && this.tTable.cCache != null) {
            this.bChanged = false;
            this.tTable.cCache.free(this, this.iPos, this.iSize);
        }
    }

    void free() throws SQLException {
        this.rLast.rNext = this.rNext;
        this.rNext.rLast = this.rLast;
        if (this.rNext == this) {
            this.rLast = null;
            this.rNext = null;
        }
    }

    Object[] getData() {
        this.iLastAccess = iCurrentAccess++;
        return this.oData;
    }

    Node getNode(int n) {
        Node node = this.nFirstIndex;
        while (n-- > 0) {
            node = node.nNext;
        }
        return node;
    }

    Node getNode(int n, int n2) throws SQLException {
        Row row = this.tTable.cCache.getRow(n, this.tTable);
        row.iLastAccess = iCurrentAccess++;
        return row.getNode(n2);
    }

    private Row getRow(int n) throws SQLException {
        return this.tTable.cCache.getRow(n, this.tTable);
    }

    void insert(Row row) {
        if (row == null) {
            this.rNext = this;
            this.rLast = this;
        } else {
            this.rNext = row;
            this.rLast = row.rLast;
            row.rLast = this;
            this.rLast.rNext = this;
        }
    }

    byte[] write() throws IOException, SQLException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(this.iSize);
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        dataOutputStream.writeInt(this.iSize);
        this.nFirstIndex.write(dataOutputStream);
        Column.writeData(dataOutputStream, this.oData, this.tTable);
        dataOutputStream.writeInt(this.iPos);
        this.bChanged = false;
        return byteArrayOutputStream.toByteArray();
    }
}

