/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import org.apache.batik.bridge.Bridge;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.ClipBridge;
import org.apache.batik.bridge.DefaultUnitProcessorContext;
import org.apache.batik.bridge.FilterBridge;
import org.apache.batik.bridge.IllegalAttributeValueException;
import org.apache.batik.bridge.MarkerBridge;
import org.apache.batik.bridge.MaskBridge;
import org.apache.batik.bridge.PaintBridge;
import org.apache.batik.bridge.SVGColorProfileElementBridge;
import org.apache.batik.bridge.SVGUtilities;
import org.apache.batik.bridge.URIResolver;
import org.apache.batik.bridge.resources.Messages;
import org.apache.batik.css.AbstractViewCSS;
import org.apache.batik.css.CSSOMReadOnlyStyleDeclaration;
import org.apache.batik.css.CSSOMReadOnlyValue;
import org.apache.batik.css.value.ImmutableString;
import org.apache.batik.dom.svg.SVGOMDocument;
import org.apache.batik.dom.util.XLinkSupport;
import org.apache.batik.ext.awt.color.ICCColorSpaceExt;
import org.apache.batik.ext.awt.image.renderable.Clip;
import org.apache.batik.ext.awt.image.renderable.Filter;
import org.apache.batik.ext.awt.image.renderable.FilterAlphaRable;
import org.apache.batik.ext.awt.image.renderable.FloodRable8Bit;
import org.apache.batik.gvt.CompositeGraphicsNode;
import org.apache.batik.gvt.CompositeShapePainter;
import org.apache.batik.gvt.FillShapePainter;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.gvt.Marker;
import org.apache.batik.gvt.ShapePainter;
import org.apache.batik.gvt.StrokeShapePainter;
import org.apache.batik.gvt.filter.BackgroundRable8Bit;
import org.apache.batik.gvt.filter.Mask;
import org.apache.batik.util.SVGConstants;
import org.apache.batik.util.UnitProcessor;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.css.CSSPrimitiveValue;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.css.CSSValue;
import org.w3c.dom.css.CSSValueList;
import org.w3c.dom.css.RGBColor;
import org.w3c.dom.css.Rect;
import org.w3c.dom.css.ViewCSS;
import org.w3c.dom.svg.SVGColor;
import org.w3c.dom.svg.SVGDocument;
import org.w3c.dom.svg.SVGElement;
import org.w3c.dom.svg.SVGICCColor;
import org.w3c.dom.svg.SVGNumberList;
import org.w3c.dom.svg.SVGPaint;

public class CSSUtilities
implements SVGConstants {
    public static final int RULE_NONZERO = 0;
    public static final int RULE_EVENODD = 1;
    public static final int LINECAP_BUTT = 0;
    public static final int LINECAP_ROUND = 1;
    public static final int LINECAP_SQUARE = 2;
    public static final int LINEJOIN_BEVEL = 0;
    public static final int LINEJOIN_ROUND = 1;
    public static final int LINEJOIN_MITER = 2;
    static Rectangle2D infiniteFilterRegion = new Rectangle2D.Float(-1.7014117E38f, -1.7014117E38f, Float.MAX_VALUE, Float.MAX_VALUE);

    protected CSSUtilities() {
    }

    public static ViewCSS getViewCSS(Element element) {
        return (ViewCSS)((SVGOMDocument)element.getOwnerDocument()).getDefaultView();
    }

    public static CSSStyleDeclaration getComputedStyle(Element element) {
        return CSSUtilities.getViewCSS(element).getComputedStyle(element, null);
    }

    public static void computeStyleAndURIs(Element element, ViewCSS viewCSS, Element element2, ViewCSS viewCSS2, URL uRL) {
        String string = XLinkSupport.getXLinkHref(element2);
        if (!string.equals("")) {
            try {
                XLinkSupport.setXLinkHref(element2, new URL(uRL, string).toString());
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        AbstractViewCSS abstractViewCSS = (AbstractViewCSS)viewCSS;
        CSSOMReadOnlyStyleDeclaration cSSOMReadOnlyStyleDeclaration = (CSSOMReadOnlyStyleDeclaration)abstractViewCSS.computeStyle(element, null);
        try {
            CSSUtilities.updateURIs(cSSOMReadOnlyStyleDeclaration, uRL);
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
        }
        ((AbstractViewCSS)viewCSS2).setComputedStyle(element2, null, cSSOMReadOnlyStyleDeclaration);
        Node node = element.getFirstChild();
        Node node2 = element2.getFirstChild();
        while (node != null) {
            if (node.getNodeType() == 1) {
                CSSUtilities.computeStyleAndURIs((Element)node, viewCSS, (Element)node2, viewCSS2, uRL);
            }
            node = node.getNextSibling();
            node2 = node2.getNextSibling();
        }
    }

    protected static void updateURIs(CSSOMReadOnlyStyleDeclaration cSSOMReadOnlyStyleDeclaration, URL uRL) throws MalformedURLException {
        int n = cSSOMReadOnlyStyleDeclaration.getLength();
        int n2 = 0;
        while (n2 < n) {
            CSSPrimitiveValue cSSPrimitiveValue;
            String string = cSSOMReadOnlyStyleDeclaration.item(n2);
            CSSValue cSSValue = cSSOMReadOnlyStyleDeclaration.getLocalPropertyCSSValue(string);
            if (cSSValue != null && cSSValue.getCssValueType() == 1 && (cSSPrimitiveValue = (CSSPrimitiveValue)cSSValue).getPrimitiveType() == 20) {
                CSSOMReadOnlyValue cSSOMReadOnlyValue = new CSSOMReadOnlyValue(new ImmutableString(20, new URL(uRL, cSSPrimitiveValue.getStringValue()).toString()));
                cSSOMReadOnlyStyleDeclaration.setPropertyCSSValue(string, cSSOMReadOnlyValue, cSSOMReadOnlyStyleDeclaration.getLocalPropertyPriority(string), cSSOMReadOnlyStyleDeclaration.getLocalPropertyOrigin(string));
            }
            ++n2;
        }
    }

    public static Rectangle2D convertEnableBackground(SVGElement sVGElement, CSSStyleDeclaration cSSStyleDeclaration, UnitProcessor.Context context) {
        CSSValue cSSValue = cSSStyleDeclaration.getPropertyCSSValue("enable-background");
        if (cSSValue.getCssValueType() != 2) {
            return null;
        }
        try {
            CSSValueList cSSValueList = (CSSValueList)cSSValue;
            int n = cSSValueList.getLength();
            switch (n) {
                case 1: {
                    return CompositeGraphicsNode.VIEWPORT;
                }
                case 5: {
                    CSSPrimitiveValue cSSPrimitiveValue = (CSSPrimitiveValue)cSSValueList.item(1);
                    short s = cSSPrimitiveValue.getPrimitiveType();
                    float f = UnitProcessor.cssToUserSpace(s, cSSPrimitiveValue.getFloatValue(s), sVGElement, (short)0, context);
                    cSSPrimitiveValue = (CSSPrimitiveValue)cSSValueList.item(2);
                    s = cSSPrimitiveValue.getPrimitiveType();
                    float f2 = UnitProcessor.cssToUserSpace(s, cSSPrimitiveValue.getFloatValue(s), sVGElement, (short)0, context);
                    cSSPrimitiveValue = (CSSPrimitiveValue)cSSValueList.item(3);
                    s = cSSPrimitiveValue.getPrimitiveType();
                    float f3 = UnitProcessor.cssToUserSpace(s, cSSPrimitiveValue.getFloatValue(s), sVGElement, (short)0, context);
                    if (f3 < 0.0f) {
                        return null;
                    }
                    cSSPrimitiveValue = (CSSPrimitiveValue)cSSValueList.item(4);
                    s = cSSPrimitiveValue.getPrimitiveType();
                    float f4 = UnitProcessor.cssToUserSpace(s, cSSPrimitiveValue.getFloatValue(s), sVGElement, (short)0, context);
                    if (f4 < 0.0f) {
                        return null;
                    }
                    return new Rectangle2D.Float(f, f2, f3, f4);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static Composite convertOpacityToComposite(CSSPrimitiveValue cSSPrimitiveValue) {
        float f = CSSUtilities.convertOpacity(cSSPrimitiveValue);
        AlphaComposite alphaComposite = null;
        if (f > 0.0f) {
            alphaComposite = f < 1.0f ? AlphaComposite.getInstance(3, f) : AlphaComposite.SrcOver;
        }
        return alphaComposite;
    }

    public static float convertOpacity(CSSPrimitiveValue cSSPrimitiveValue) {
        float f = cSSPrimitiveValue.getFloatValue((short)1);
        return f < 0.0f ? 0.0f : (f > 1.0f ? 1.0f : f);
    }

    public static int rule(CSSPrimitiveValue cSSPrimitiveValue) {
        if (cSSPrimitiveValue.getStringValue().charAt(0) == 'n') {
            return 0;
        }
        return 1;
    }

    public static boolean convertVisibility(Element element) {
        CSSStyleDeclaration cSSStyleDeclaration = CSSUtilities.getComputedStyle(element);
        CSSValue cSSValue = cSSStyleDeclaration.getPropertyCSSValue("visibility");
        if (cSSValue.getCssValueType() == 0) {
            return true;
        }
        return ((CSSPrimitiveValue)cSSValue).getStringValue().charAt(0) == 'v';
    }

    public static Color convertColor(RGBColor rGBColor, float f) {
        int n = CSSUtilities.resolveColorComponent(rGBColor.getRed());
        int n2 = CSSUtilities.resolveColorComponent(rGBColor.getGreen());
        int n3 = CSSUtilities.resolveColorComponent(rGBColor.getBlue());
        return new Color(n, n2, n3, Math.round(f * 255.0f));
    }

    public static boolean convertOverflow(Element element) {
        CSSStyleDeclaration cSSStyleDeclaration = CSSUtilities.getComputedStyle(element);
        CSSPrimitiveValue cSSPrimitiveValue = (CSSPrimitiveValue)cSSStyleDeclaration.getPropertyCSSValue("overflow");
        String string = cSSPrimitiveValue.getStringValue();
        return string.charAt(0) == 'h' || string.charAt(0) == 's';
    }

    public static float[] convertClip(Element element) {
        CSSStyleDeclaration cSSStyleDeclaration = CSSUtilities.getComputedStyle(element);
        CSSPrimitiveValue cSSPrimitiveValue = (CSSPrimitiveValue)cSSStyleDeclaration.getPropertyCSSValue("clip");
        switch (cSSPrimitiveValue.getPrimitiveType()) {
            case 24: {
                float[] fArray = new float[4];
                Rect rect = cSSPrimitiveValue.getRectValue();
                fArray[0] = rect.getTop().getFloatValue((short)1);
                fArray[1] = rect.getRight().getFloatValue((short)1);
                fArray[2] = rect.getBottom().getFloatValue((short)1);
                fArray[3] = rect.getLeft().getFloatValue((short)1);
                return fArray;
            }
            case 21: {
                return null;
            }
        }
        throw new Error();
    }

    public static Clip convertClipPath(Element element, GraphicsNode graphicsNode, BridgeContext bridgeContext) {
        CSSStyleDeclaration cSSStyleDeclaration = CSSUtilities.getComputedStyle(element);
        CSSPrimitiveValue cSSPrimitiveValue = (CSSPrimitiveValue)cSSStyleDeclaration.getPropertyCSSValue("clip-path");
        switch (cSSPrimitiveValue.getPrimitiveType()) {
            case 21: {
                return null;
            }
            case 20: {
                String string = cSSPrimitiveValue.getStringValue();
                URIResolver uRIResolver = new URIResolver((SVGDocument)element.getOwnerDocument(), bridgeContext.getDocumentLoader());
                Element element2 = null;
                try {
                    element2 = uRIResolver.getElement(string);
                }
                catch (Exception exception) {
                    throw new IllegalAttributeValueException(Messages.formatMessage("bad.uri", new Object[]{string}));
                }
                Bridge bridge = bridgeContext.getBridge(element2);
                if (bridge == null || !(bridge instanceof ClipBridge)) {
                    throw new IllegalAttributeValueException(Messages.formatMessage("clipPath.reference.illegal", new Object[]{element2.getLocalName()}));
                }
                ClipBridge clipBridge = (ClipBridge)bridge;
                SVGOMDocument sVGOMDocument = (SVGOMDocument)element2.getOwnerDocument();
                Clip clip = clipBridge.createClip(bridgeContext, graphicsNode, element2, element);
                return clip;
            }
        }
        throw new Error();
    }

    public static Mask convertMask(Element element, GraphicsNode graphicsNode, BridgeContext bridgeContext) {
        CSSStyleDeclaration cSSStyleDeclaration = CSSUtilities.getComputedStyle(element);
        CSSPrimitiveValue cSSPrimitiveValue = (CSSPrimitiveValue)cSSStyleDeclaration.getPropertyCSSValue("mask");
        switch (cSSPrimitiveValue.getPrimitiveType()) {
            case 21: {
                return null;
            }
            case 20: {
                String string = cSSPrimitiveValue.getStringValue();
                URIResolver uRIResolver = new URIResolver((SVGDocument)element.getOwnerDocument(), bridgeContext.getDocumentLoader());
                Element element2 = null;
                try {
                    element2 = uRIResolver.getElement(string);
                }
                catch (Exception exception) {
                    throw new IllegalAttributeValueException(Messages.formatMessage("bad.uri", new Object[]{string}));
                }
                Bridge bridge = bridgeContext.getBridge(element2);
                if (bridge == null || !(bridge instanceof MaskBridge)) {
                    throw new IllegalAttributeValueException(Messages.formatMessage("mask.reference.illegal", new Object[]{element2.getLocalName()}));
                }
                MaskBridge maskBridge = (MaskBridge)bridge;
                SVGOMDocument sVGOMDocument = (SVGOMDocument)element2.getOwnerDocument();
                Mask mask = maskBridge.createMask(graphicsNode, bridgeContext, element2, element);
                return mask;
            }
        }
        throw new Error();
    }

    public static ShapePainter convertStrokeAndFill(Shape shape, SVGElement sVGElement, GraphicsNode graphicsNode, BridgeContext bridgeContext, CSSStyleDeclaration cSSStyleDeclaration, UnitProcessor.Context context) {
        ShapePainter shapePainter = CSSUtilities.convertFill(shape, sVGElement, graphicsNode, bridgeContext, cSSStyleDeclaration, context);
        ShapePainter shapePainter2 = CSSUtilities.convertStroke(shape, sVGElement, graphicsNode, bridgeContext, cSSStyleDeclaration, context);
        ShapePainter shapePainter3 = null;
        if (shapePainter != null && shapePainter2 != null) {
            CompositeShapePainter compositeShapePainter = new CompositeShapePainter(shape);
            compositeShapePainter.addShapePainter(shapePainter);
            compositeShapePainter.addShapePainter(shapePainter2);
            shapePainter3 = compositeShapePainter;
        } else if (shapePainter != null) {
            shapePainter3 = shapePainter;
        } else if (shapePainter2 != null) {
            shapePainter3 = shapePainter2;
        }
        return shapePainter3;
    }

    public static ShapePainter convertStroke(Shape shape, SVGElement sVGElement, GraphicsNode graphicsNode, BridgeContext bridgeContext, CSSStyleDeclaration cSSStyleDeclaration, UnitProcessor.Context context) {
        BasicStroke basicStroke = CSSUtilities.convertStrokeToBasicStroke(sVGElement, bridgeContext, cSSStyleDeclaration, context);
        Paint paint = CSSUtilities.convertStrokeToPaint(sVGElement, graphicsNode, bridgeContext, cSSStyleDeclaration, context);
        StrokeShapePainter strokeShapePainter = new StrokeShapePainter(shape);
        strokeShapePainter.setStroke(basicStroke);
        strokeShapePainter.setPaint(paint);
        return strokeShapePainter;
    }

    public static Paint convertStrokeToPaint(SVGElement sVGElement, GraphicsNode graphicsNode, BridgeContext bridgeContext, CSSStyleDeclaration cSSStyleDeclaration, UnitProcessor.Context context) {
        CSSValue cSSValue = cSSStyleDeclaration.getPropertyCSSValue("stroke");
        CSSPrimitiveValue cSSPrimitiveValue = (CSSPrimitiveValue)cSSStyleDeclaration.getPropertyCSSValue("stroke-opacity");
        float f = CSSUtilities.convertOpacity(cSSPrimitiveValue);
        return CSSUtilities.convertPaintDefinitionToPaint(sVGElement, graphicsNode, bridgeContext, cSSStyleDeclaration, context, cSSValue, f, true);
    }

    public static Paint convertPaintDefinitionToPaint(SVGElement sVGElement, GraphicsNode graphicsNode, BridgeContext bridgeContext, CSSStyleDeclaration cSSStyleDeclaration, UnitProcessor.Context context, CSSValue cSSValue, float f, boolean bl) {
        if (cSSValue.getCssValueType() == 1) {
            CSSPrimitiveValue cSSPrimitiveValue = (CSSPrimitiveValue)cSSValue;
            switch (cSSPrimitiveValue.getPrimitiveType()) {
                case 21: {
                    return null;
                }
                case 25: {
                    return CSSUtilities.convertColor(cSSPrimitiveValue.getRGBColorValue(), f);
                }
                case 20: {
                    return CSSUtilities.convertURIToPaint(sVGElement, graphicsNode, bridgeContext, cSSStyleDeclaration, context, cSSPrimitiveValue.getStringValue(), bl);
                }
            }
            throw new Error();
        }
        SVGPaint sVGPaint = (SVGPaint)cSSValue;
        Paint paint = null;
        switch (sVGPaint.getPaintType()) {
            case 2: {
                return CSSUtilities.convertRGBICCColor(sVGElement, sVGPaint, f, bridgeContext);
            }
            case 103: {
                return CSSUtilities.silentConvertURIPaint(sVGElement, graphicsNode, bridgeContext, cSSStyleDeclaration, context, sVGPaint, f, bl);
            }
            case 104: {
                paint = CSSUtilities.silentConvertURIPaint(sVGElement, graphicsNode, bridgeContext, cSSStyleDeclaration, context, sVGPaint, f, bl);
                if (paint == null) {
                    CSSValue cSSValue2 = cSSStyleDeclaration.getPropertyCSSValue("color");
                    paint = CSSUtilities.convertColor(((CSSPrimitiveValue)cSSValue2).getRGBColorValue(), f);
                }
                return paint;
            }
            case 105: {
                paint = CSSUtilities.silentConvertURIPaint(sVGElement, graphicsNode, bridgeContext, cSSStyleDeclaration, context, sVGPaint, f, bl);
                if (paint == null) {
                    paint = CSSUtilities.convertColor(sVGPaint.getRGBColor(), f);
                }
                return paint;
            }
            case 106: {
                paint = CSSUtilities.silentConvertURIPaint(sVGElement, graphicsNode, bridgeContext, cSSStyleDeclaration, context, sVGPaint, f, bl);
                if (paint == null) {
                    paint = CSSUtilities.convertRGBICCColor(sVGElement, sVGPaint, f, bridgeContext);
                }
                return paint;
            }
        }
        throw new Error();
    }

    public static Paint silentConvertURIPaint(SVGElement sVGElement, GraphicsNode graphicsNode, BridgeContext bridgeContext, CSSStyleDeclaration cSSStyleDeclaration, UnitProcessor.Context context, SVGPaint sVGPaint, float f, boolean bl) {
        Paint paint = null;
        try {
            paint = CSSUtilities.convertURIToPaint(sVGElement, graphicsNode, bridgeContext, cSSStyleDeclaration, context, sVGPaint.getUri(), bl);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return paint;
    }

    public static Color convertRGBICCColor(Element element, SVGColor sVGColor, float f, BridgeContext bridgeContext) {
        SVGICCColor sVGICCColor = sVGColor.getICCColor();
        Color color = null;
        if (sVGICCColor != null) {
            color = CSSUtilities.convertICCColor(element, sVGICCColor, f, bridgeContext);
        }
        if (color == null) {
            color = CSSUtilities.convertColor(sVGColor.getRGBColor(), f);
        }
        return color;
    }

    public static Color convertICCColor(Element element, SVGICCColor sVGICCColor, float f, BridgeContext bridgeContext) {
        String string = sVGICCColor.getColorProfile();
        if (string == null) {
            return null;
        }
        SVGColorProfileElementBridge sVGColorProfileElementBridge = (SVGColorProfileElementBridge)bridgeContext.getBridge("http://www.w3.org/2000/svg", "color-profile");
        if (sVGColorProfileElementBridge == null) {
            return null;
        }
        ICCColorSpaceExt iCCColorSpaceExt = sVGColorProfileElementBridge.build(string, bridgeContext, element);
        if (iCCColorSpaceExt == null) {
            return null;
        }
        float[] fArray = CSSUtilities.convertSVGNumberList(sVGICCColor.getColors());
        if (fArray == null) {
            return null;
        }
        float[] fArray2 = iCCColorSpaceExt.intendedToRGB(fArray);
        return new Color(fArray2[0], fArray2[1], fArray2[2], f);
    }

    public static float[] convertSVGNumberList(SVGNumberList sVGNumberList) {
        int n = sVGNumberList.getNumberOfItems();
        float[] fArray = new float[n];
        try {
            int n2 = 0;
            while (n2 < n) {
                fArray[n2] = sVGNumberList.getItem(n2).getValue();
                ++n2;
            }
        }
        catch (DOMException dOMException) {
            dOMException.printStackTrace();
            fArray = null;
        }
        return fArray;
    }

    public static BasicStroke convertStrokeToBasicStroke(SVGElement sVGElement, BridgeContext bridgeContext, CSSStyleDeclaration cSSStyleDeclaration, UnitProcessor.Context context) {
        Object object;
        int n;
        int n2;
        CSSPrimitiveValue cSSPrimitiveValue = (CSSPrimitiveValue)cSSStyleDeclaration.getPropertyCSSValue("stroke-width");
        short s = cSSPrimitiveValue.getPrimitiveType();
        float f = UnitProcessor.cssToUserSpace(s, cSSPrimitiveValue.getFloatValue(s), sVGElement, (short)0, context);
        cSSPrimitiveValue = (CSSPrimitiveValue)cSSStyleDeclaration.getPropertyCSSValue("stroke-linecap");
        switch (CSSUtilities.parseStrokeLinecapProperty(cSSPrimitiveValue.getStringValue())) {
            case 0: {
                n2 = 0;
                break;
            }
            case 1: {
                n2 = 1;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
            default: {
                throw new Error();
            }
        }
        cSSPrimitiveValue = (CSSPrimitiveValue)cSSStyleDeclaration.getPropertyCSSValue("stroke-linejoin");
        switch (CSSUtilities.parseStrokeLinejoinProperty(cSSPrimitiveValue.getStringValue())) {
            case 2: {
                n = 0;
                break;
            }
            case 0: {
                n = 2;
                break;
            }
            case 1: {
                n = 1;
                break;
            }
            default: {
                throw new Error();
            }
        }
        cSSPrimitiveValue = (CSSPrimitiveValue)cSSStyleDeclaration.getPropertyCSSValue("stroke-miterlimit");
        float f2 = cSSPrimitiveValue.getFloatValue((short)1);
        f2 = f2 < 1.0f ? 1.0f : f2;
        CSSValue cSSValue = cSSStyleDeclaration.getPropertyCSSValue("stroke-dasharray");
        float[] fArray = null;
        float f3 = 0.0f;
        if (cSSValue.getCssValueType() == 2) {
            object = (CSSValueList)cSSValue;
            int n3 = object.getLength();
            fArray = new float[n3];
            float f4 = 0.0f;
            int n4 = 0;
            while (n4 < n3) {
                cSSPrimitiveValue = (CSSPrimitiveValue)object.item(n4);
                s = cSSPrimitiveValue.getPrimitiveType();
                fArray[n4] = UnitProcessor.cssToUserSpace(s, cSSPrimitiveValue.getFloatValue(s), sVGElement, (short)0, context);
                f4 += fArray[n4];
                ++n4;
            }
            if (f4 == 0.0f) {
                fArray = null;
            } else {
                cSSPrimitiveValue = (CSSPrimitiveValue)cSSStyleDeclaration.getPropertyCSSValue("stroke-dashoffset");
                s = cSSPrimitiveValue.getPrimitiveType();
                f3 = UnitProcessor.cssToUserSpace(s, cSSPrimitiveValue.getFloatValue(s), sVGElement, (short)0, context);
            }
        }
        object = new BasicStroke(f, n2, n, f2, fArray, f3);
        return object;
    }

    public static ShapePainter convertFill(Shape shape, SVGElement sVGElement, GraphicsNode graphicsNode, BridgeContext bridgeContext, CSSStyleDeclaration cSSStyleDeclaration, UnitProcessor.Context context) {
        FillShapePainter fillShapePainter = null;
        Paint paint = CSSUtilities.convertFillToPaint(sVGElement, graphicsNode, bridgeContext, cSSStyleDeclaration, context);
        if (paint != null) {
            fillShapePainter = new FillShapePainter(shape);
            fillShapePainter.setPaint(paint);
        }
        return fillShapePainter;
    }

    public static Paint convertURIToPaint(SVGElement sVGElement, GraphicsNode graphicsNode, BridgeContext bridgeContext, CSSStyleDeclaration cSSStyleDeclaration, UnitProcessor.Context context, String string, boolean bl) {
        URIResolver uRIResolver = new URIResolver((SVGDocument)sVGElement.getOwnerDocument(), bridgeContext.getDocumentLoader());
        Element element = null;
        try {
            element = uRIResolver.getElement(string);
        }
        catch (Exception exception) {
            throw new IllegalAttributeValueException(Messages.formatMessage("bad.uri", new Object[]{string}));
        }
        Bridge bridge = bridgeContext.getBridge(element);
        if (bridge == null || !(bridge instanceof PaintBridge)) {
            throw new IllegalAttributeValueException(Messages.formatMessage("paint.reference.illegal", new Object[]{element.getLocalName()}));
        }
        PaintBridge paintBridge = (PaintBridge)bridge;
        SVGOMDocument sVGOMDocument = (SVGOMDocument)element.getOwnerDocument();
        Paint paint = null;
        paint = bl ? paintBridge.createStrokePaint(bridgeContext, graphicsNode, sVGElement, element) : paintBridge.createFillPaint(bridgeContext, graphicsNode, sVGElement, element);
        return paint;
    }

    public static Paint convertFillToPaint(SVGElement sVGElement, GraphicsNode graphicsNode, BridgeContext bridgeContext, CSSStyleDeclaration cSSStyleDeclaration, UnitProcessor.Context context) {
        CSSValue cSSValue = cSSStyleDeclaration.getPropertyCSSValue("fill");
        CSSPrimitiveValue cSSPrimitiveValue = (CSSPrimitiveValue)cSSStyleDeclaration.getPropertyCSSValue("fill-opacity");
        float f = CSSUtilities.convertOpacity(cSSPrimitiveValue);
        return CSSUtilities.convertPaintDefinitionToPaint(sVGElement, graphicsNode, bridgeContext, cSSStyleDeclaration, context, cSSValue, f, false);
    }

    public static Marker convertMarker(SVGElement sVGElement, String string, BridgeContext bridgeContext, CSSStyleDeclaration cSSStyleDeclaration, UnitProcessor.Context context) {
        CSSPrimitiveValue cSSPrimitiveValue = (CSSPrimitiveValue)cSSStyleDeclaration.getPropertyCSSValue(string);
        if (cSSPrimitiveValue == null) {
            return null;
        }
        switch (cSSPrimitiveValue.getPrimitiveType()) {
            case 21: {
                return null;
            }
            case 20: {
                return CSSUtilities.convertURIToMarker(cSSPrimitiveValue.getStringValue(), sVGElement, bridgeContext, cSSStyleDeclaration, context);
            }
        }
        throw new Error();
    }

    public static Marker convertURIToMarker(String string, SVGElement sVGElement, BridgeContext bridgeContext, CSSStyleDeclaration cSSStyleDeclaration, UnitProcessor.Context context) {
        URIResolver uRIResolver = new URIResolver((SVGDocument)sVGElement.getOwnerDocument(), bridgeContext.getDocumentLoader());
        Element element = null;
        try {
            element = uRIResolver.getElement(string);
        }
        catch (Exception exception) {
            throw new IllegalAttributeValueException(Messages.formatMessage("bad.uri", new Object[]{string}));
        }
        Bridge bridge = bridgeContext.getBridge(element);
        if (bridge == null || !(bridge instanceof MarkerBridge)) {
            throw new IllegalAttributeValueException(Messages.formatMessage("marker.reference.illegal", new Object[]{element.getLocalName()}));
        }
        MarkerBridge markerBridge = (MarkerBridge)bridge;
        Marker marker = markerBridge.buildMarker(bridgeContext, element, sVGElement);
        return marker;
    }

    public static Color convertFloodColorToPaint(Element element, CSSStyleDeclaration cSSStyleDeclaration, BridgeContext bridgeContext) {
        CSSValue cSSValue = cSSStyleDeclaration.getPropertyCSSValue("flood-color");
        CSSPrimitiveValue cSSPrimitiveValue = (CSSPrimitiveValue)cSSStyleDeclaration.getPropertyCSSValue("flood-opacity");
        float f = CSSUtilities.convertOpacity(cSSPrimitiveValue);
        if (cSSValue.getCssValueType() == 1) {
            CSSPrimitiveValue cSSPrimitiveValue2 = (CSSPrimitiveValue)cSSValue;
            return CSSUtilities.convertColor(cSSPrimitiveValue2.getRGBColorValue(), f);
        }
        SVGColor sVGColor = (SVGColor)cSSValue;
        return CSSUtilities.convertRGBICCColor(element, sVGColor, f, bridgeContext);
    }

    public static Color convertLightingColor(Element element, CSSStyleDeclaration cSSStyleDeclaration, BridgeContext bridgeContext) {
        CSSValue cSSValue = cSSStyleDeclaration.getPropertyCSSValue("lighting-color");
        if (cSSValue.getCssValueType() == 1) {
            CSSPrimitiveValue cSSPrimitiveValue = (CSSPrimitiveValue)cSSValue;
            return CSSUtilities.convertColor(cSSPrimitiveValue.getRGBColorValue(), 1.0f);
        }
        SVGColor sVGColor = (SVGColor)cSSValue;
        return CSSUtilities.convertRGBICCColor(element, sVGColor, 1.0f, bridgeContext);
    }

    public static Color convertStopColorToPaint(Element element, CSSStyleDeclaration cSSStyleDeclaration, float f, BridgeContext bridgeContext) {
        CSSValue cSSValue = cSSStyleDeclaration.getPropertyCSSValue("stop-color");
        CSSPrimitiveValue cSSPrimitiveValue = (CSSPrimitiveValue)cSSStyleDeclaration.getPropertyCSSValue("stop-opacity");
        float f2 = f * CSSUtilities.convertOpacity(cSSPrimitiveValue);
        if (cSSValue.getCssValueType() == 1) {
            CSSPrimitiveValue cSSPrimitiveValue2 = (CSSPrimitiveValue)cSSValue;
            return CSSUtilities.convertColor(cSSPrimitiveValue2.getRGBColorValue(), f2);
        }
        SVGColor sVGColor = (SVGColor)cSSValue;
        return CSSUtilities.convertRGBICCColor(element, sVGColor, f2, bridgeContext);
    }

    protected static int resolveColorComponent(CSSPrimitiveValue cSSPrimitiveValue) {
        switch (cSSPrimitiveValue.getPrimitiveType()) {
            case 2: {
                float f = cSSPrimitiveValue.getFloatValue((short)2);
                f = f > 100.0f ? 100.0f : (f < 0.0f ? 0.0f : f);
                return Math.round(255.0f * f / 100.0f);
            }
            case 1: {
                float f = cSSPrimitiveValue.getFloatValue((short)1);
                f = f > 255.0f ? 255.0f : (f < 0.0f ? 0.0f : f);
                return Math.round(f);
            }
        }
        throw new Error();
    }

    public static int parseStrokeLinecapProperty(String string) {
        switch (string.charAt(0)) {
            case 'b': {
                return 0;
            }
            case 'r': {
                return 1;
            }
            case 's': {
                return 2;
            }
        }
        throw new Error();
    }

    public static int parseStrokeLinejoinProperty(String string) {
        switch (string.charAt(0)) {
            case 'm': {
                return 2;
            }
            case 'r': {
                return 1;
            }
            case 'b': {
                return 0;
            }
        }
        throw new Error();
    }

    public static float convertFontSize(SVGElement sVGElement, BridgeContext bridgeContext, CSSStyleDeclaration cSSStyleDeclaration, UnitProcessor.Context context) {
        CSSPrimitiveValue cSSPrimitiveValue = (CSSPrimitiveValue)cSSStyleDeclaration.getPropertyCSSValue("font-size");
        short s = cSSPrimitiveValue.getPrimitiveType();
        switch (s) {
            case 21: {
                float f = context.getMediumFontSize();
                f = CSSUtilities.parseFontSize(cSSPrimitiveValue.getStringValue(), f);
                return UnitProcessor.cssToUserSpace((short)9, f, sVGElement, (short)1, context);
            }
        }
        return UnitProcessor.cssToUserSpace(s, cSSPrimitiveValue.getFloatValue(s), sVGElement, (short)1, context);
    }

    public static float parseFontSize(String string, float f) {
        switch (string.charAt(0)) {
            case 'm': {
                return f;
            }
            case 's': {
                return (float)((double)f / 1.2);
            }
            case 'l': {
                return (float)((double)f * 1.2);
            }
        }
        switch (string.charAt(1)) {
            case 'x': {
                switch (string.charAt(3)) {
                    case 's': {
                        return (float)((double)f / 1.2 / 1.2 / 1.2);
                    }
                }
                return (float)((double)f * 1.2 * 1.2 * 1.2);
            }
        }
        switch (string.charAt(2)) {
            case 's': {
                return (float)((double)f / 1.2 / 1.2);
            }
        }
        return (float)((double)f * 1.2 * 1.2);
    }

    public static Filter convertFilter(Element element, GraphicsNode graphicsNode, BridgeContext bridgeContext) {
        CSSStyleDeclaration cSSStyleDeclaration = CSSUtilities.getComputedStyle(element);
        CSSPrimitiveValue cSSPrimitiveValue = (CSSPrimitiveValue)cSSStyleDeclaration.getPropertyCSSValue("filter");
        switch (cSSPrimitiveValue.getPrimitiveType()) {
            case 21: {
                return null;
            }
            case 20: {
                String string = cSSPrimitiveValue.getStringValue();
                URIResolver uRIResolver = new URIResolver((SVGDocument)element.getOwnerDocument(), bridgeContext.getDocumentLoader());
                Element element2 = null;
                try {
                    element2 = uRIResolver.getElement(string);
                }
                catch (Exception exception) {
                    throw new IllegalAttributeValueException(Messages.formatMessage("bad.uri", new Object[]{string}));
                }
                Bridge bridge = bridgeContext.getBridge(element2);
                if (bridge == null || !(bridge instanceof FilterBridge)) {
                    throw new IllegalAttributeValueException(Messages.formatMessage("filter.reference.illegal", new Object[]{element2.getLocalName()}));
                }
                FilterBridge filterBridge = (FilterBridge)bridge;
                SVGOMDocument sVGOMDocument = (SVGOMDocument)element2.getOwnerDocument();
                Filter filter = filterBridge.create(graphicsNode, bridgeContext, element2, element, null, null, null);
                return filter;
            }
        }
        throw new Error();
    }

    public static Filter getFilterSource(GraphicsNode graphicsNode, String string, BridgeContext bridgeContext, Element element, Filter filter, Map map) {
        int n = SVGUtilities.parseInAttribute(string);
        switch (n) {
            case 0: {
                return filter;
            }
            case 7: {
                return (Filter)map.get(string);
            }
            case 5: {
                return (Filter)map.get("SourceGraphic");
            }
            case 4: {
                filter = (Filter)map.get("SourceGraphic");
                filter = new FilterAlphaRable(filter);
                return filter;
            }
            case 3: {
                CSSStyleDeclaration cSSStyleDeclaration = CSSUtilities.getComputedStyle(element);
                DefaultUnitProcessorContext defaultUnitProcessorContext = new DefaultUnitProcessorContext(bridgeContext, cSSStyleDeclaration);
                Paint paint = CSSUtilities.convertFillToPaint((SVGElement)element, graphicsNode, bridgeContext, cSSStyleDeclaration, defaultUnitProcessorContext);
                if (paint == null) {
                    paint = new Color(0, 0, 0, 0);
                }
                return new FloodRable8Bit(infiniteFilterRegion, paint);
            }
            case 6: {
                CSSStyleDeclaration cSSStyleDeclaration = CSSUtilities.getComputedStyle(element);
                DefaultUnitProcessorContext defaultUnitProcessorContext = new DefaultUnitProcessorContext(bridgeContext, cSSStyleDeclaration);
                Paint paint = CSSUtilities.convertStrokeToPaint((SVGElement)element, graphicsNode, bridgeContext, cSSStyleDeclaration, defaultUnitProcessorContext);
                return new FloodRable8Bit(infiniteFilterRegion, paint);
            }
            case 2: {
                return new BackgroundRable8Bit(graphicsNode, bridgeContext.getGraphicsNodeRenderContext());
            }
            case 1: {
                filter = new BackgroundRable8Bit(graphicsNode, bridgeContext.getGraphicsNodeRenderContext());
                filter = new FilterAlphaRable(filter);
                return filter;
            }
        }
        throw new Error();
    }

    public static float convertRatio(String string) {
        float f;
        float f2 = 1.0f;
        if (string.endsWith("%")) {
            string = string.substring(0, string.length() - 1);
            f2 = 100.0f;
        }
        if ((f = Float.parseFloat(string) / f2) < 0.0f) {
            f = 0.0f;
        } else if (f > 1.0f) {
            f = 1.0f;
        }
        return f;
    }
}

