/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import java.awt.Composite;
import java.awt.Shape;
import java.awt.color.ICC_Profile;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.BridgeEventSupport;
import org.apache.batik.bridge.BridgeMutationEvent;
import org.apache.batik.bridge.CSSUtilities;
import org.apache.batik.bridge.DefaultUnitProcessorContext;
import org.apache.batik.bridge.DocumentLoader;
import org.apache.batik.bridge.GraphicsNodeBridge;
import org.apache.batik.bridge.IllegalAttributeValueException;
import org.apache.batik.bridge.MissingAttributeException;
import org.apache.batik.bridge.SVGColorProfileElementBridge;
import org.apache.batik.bridge.SVGUtilities;
import org.apache.batik.bridge.URIResolver;
import org.apache.batik.bridge.Viewport;
import org.apache.batik.bridge.resources.Messages;
import org.apache.batik.dom.svg.SVGOMDocument;
import org.apache.batik.dom.util.XLinkSupport;
import org.apache.batik.ext.awt.color.ICCColorSpaceExt;
import org.apache.batik.ext.awt.image.renderable.Clip;
import org.apache.batik.ext.awt.image.renderable.ClipRable8Bit;
import org.apache.batik.ext.awt.image.renderable.Filter;
import org.apache.batik.ext.awt.image.renderable.RasterRable;
import org.apache.batik.gvt.AbstractGraphicsNode;
import org.apache.batik.gvt.CompositeGraphicsNode;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.gvt.ImageNode;
import org.apache.batik.gvt.RasterImageNode;
import org.apache.batik.gvt.filter.GraphicsNodeRable;
import org.apache.batik.gvt.filter.GraphicsNodeRableFactory;
import org.apache.batik.gvt.filter.Mask;
import org.apache.batik.util.SVGConstants;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.css.CSSPrimitiveValue;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.svg.SVGDocument;
import org.w3c.dom.svg.SVGElement;
import org.w3c.dom.svg.SVGSVGElement;

public class SVGImageElementBridge
implements GraphicsNodeBridge,
SVGConstants {
    public static final String PROTOCOL_DATA = "data:";

    public GraphicsNode createGraphicsNode(BridgeContext bridgeContext, Element element) {
        Serializable serializable;
        Object object;
        Object object2;
        GraphicsNode graphicsNode;
        block11: {
            SVGElement sVGElement = (SVGElement)element;
            CSSStyleDeclaration cSSStyleDeclaration = CSSUtilities.getComputedStyle(element);
            String string = XLinkSupport.getXLinkHref(sVGElement);
            if (string.length() == 0) {
                throw new MissingAttributeException(Messages.formatMessage("image.xlinkHref.required", null));
            }
            if (string.indexOf(35) != -1) {
                throw new IllegalAttributeValueException(Messages.formatMessage("image.xlinkHref.invalid", null));
            }
            graphicsNode = null;
            try {
                if (string.startsWith(PROTOCOL_DATA)) {
                    graphicsNode = this.createBase64ImageNode(bridgeContext, sVGElement, string);
                    break block11;
                }
                object2 = (SVGDocument)element.getOwnerDocument();
                object = ((SVGOMDocument)object2).getURLObject();
                serializable = new URL((URL)object, string);
                DocumentLoader documentLoader = bridgeContext.getDocumentLoader();
                URIResolver uRIResolver = new URIResolver((SVGDocument)object2, documentLoader);
                try {
                    Node node = uRIResolver.getNode(serializable.toString());
                    if (node.getNodeType() == 9) {
                        SVGDocument sVGDocument = (SVGDocument)node;
                        graphicsNode = this.createSVGImageNode(bridgeContext, sVGElement, sVGDocument);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (graphicsNode == null) {
                    graphicsNode = this.createRasterImageNode(bridgeContext, sVGElement, (URL)serializable);
                }
            }
            catch (MalformedURLException malformedURLException) {
                throw new IllegalAttributeValueException(Messages.formatMessage("image.xlinkHref.badURL", null));
            }
        }
        if (graphicsNode == null) {
            throw new IllegalAttributeValueException(Messages.formatMessage("image.xlinkHref.badImageType", null));
        }
        object2 = new ImageNode();
        ((ImageNode)object2).setImage(graphicsNode);
        ((AbstractGraphicsNode)object2).setVisible(CSSUtilities.convertVisibility(element));
        object = element.getAttributeNS(null, "transform");
        if (((String)object).length() > 0) {
            serializable = SVGUtilities.convertAffineTransform((String)object);
            ((AbstractGraphicsNode)object2).setTransform((AffineTransform)serializable);
        }
        bridgeContext.bind(element, (GraphicsNode)object2);
        return object2;
    }

    public void buildGraphicsNode(GraphicsNode graphicsNode, BridgeContext bridgeContext, Element element) {
        CSSStyleDeclaration cSSStyleDeclaration = CSSUtilities.getComputedStyle(element);
        CSSPrimitiveValue cSSPrimitiveValue = (CSSPrimitiveValue)cSSStyleDeclaration.getPropertyCSSValue("opacity");
        Composite composite = CSSUtilities.convertOpacityToComposite(cSSPrimitiveValue);
        graphicsNode.setComposite(composite);
        Filter filter = CSSUtilities.convertFilter(element, graphicsNode, bridgeContext);
        graphicsNode.setFilter(filter);
        Mask mask = CSSUtilities.convertMask(element, graphicsNode, bridgeContext);
        graphicsNode.setMask(mask);
        Clip clip = CSSUtilities.convertClipPath(element, graphicsNode, bridgeContext);
        graphicsNode.setClip(clip);
        BridgeEventSupport.addDOMListener(bridgeContext, (SVGElement)element);
    }

    protected GraphicsNode createBase64ImageNode(BridgeContext bridgeContext, SVGElement sVGElement, String string) {
        RasterImageNode rasterImageNode = new RasterImageNode();
        Rectangle2D rectangle2D = this.getImageBounds(bridgeContext, sVGElement);
        rasterImageNode.setImage(RasterRable.create(string, rectangle2D, this.extractColorSpace(sVGElement, bridgeContext)));
        rasterImageNode.setImageBounds(rectangle2D);
        return rasterImageNode;
    }

    protected GraphicsNode createRasterImageNode(BridgeContext bridgeContext, SVGElement sVGElement, URL uRL) {
        RasterImageNode rasterImageNode = new RasterImageNode();
        Rectangle2D rectangle2D = this.getImageBounds(bridgeContext, sVGElement);
        rasterImageNode.setImage(RasterRable.create(uRL, rectangle2D, this.extractColorSpace(sVGElement, bridgeContext)));
        rasterImageNode.setImageBounds(rectangle2D);
        return rasterImageNode;
    }

    protected ICCColorSpaceExt extractColorSpace(SVGElement sVGElement, BridgeContext bridgeContext) {
        SVGColorProfileElementBridge sVGColorProfileElementBridge;
        CSSStyleDeclaration cSSStyleDeclaration = CSSUtilities.getComputedStyle(sVGElement);
        CSSPrimitiveValue cSSPrimitiveValue = (CSSPrimitiveValue)cSSStyleDeclaration.getPropertyCSSValue("color-profile");
        if (cSSPrimitiveValue.getPrimitiveType() != 21) {
            throw new Error();
        }
        String string = cSSPrimitiveValue.getStringValue();
        ICCColorSpaceExt iCCColorSpaceExt = null;
        if ("srgb".equalsIgnoreCase(string)) {
            iCCColorSpaceExt = new ICCColorSpaceExt(ICC_Profile.getInstance(1000), 4);
        } else if (!"auto".equalsIgnoreCase(string) && !"".equalsIgnoreCase(string) && (sVGColorProfileElementBridge = (SVGColorProfileElementBridge)bridgeContext.getBridge("http://www.w3.org/2000/svg", "color-profile")) != null) {
            iCCColorSpaceExt = sVGColorProfileElementBridge.build(string, bridgeContext, sVGElement);
        }
        return iCCColorSpaceExt;
    }

    protected GraphicsNode createSVGImageNode(BridgeContext bridgeContext, SVGElement sVGElement, SVGDocument sVGDocument) {
        Viewport viewport = bridgeContext.getViewport();
        bridgeContext.setViewport(null);
        SVGSVGElement sVGSVGElement = sVGDocument.getRootElement();
        CompositeGraphicsNode compositeGraphicsNode = new CompositeGraphicsNode();
        CSSStyleDeclaration cSSStyleDeclaration = CSSUtilities.getComputedStyle(sVGElement);
        DefaultUnitProcessorContext defaultUnitProcessorContext = new DefaultUnitProcessorContext(bridgeContext, cSSStyleDeclaration);
        Rectangle2D rectangle2D = CSSUtilities.convertEnableBackground(sVGElement, cSSStyleDeclaration, defaultUnitProcessorContext);
        if (rectangle2D != null) {
            compositeGraphicsNode.setBackgroundEnable(rectangle2D);
        }
        GraphicsNode graphicsNode = bridgeContext.getGVTBuilder().build(bridgeContext, sVGSVGElement);
        compositeGraphicsNode.getChildren().add(graphicsNode);
        Rectangle2D rectangle2D2 = this.getImageBounds(bridgeContext, sVGElement);
        float f = (float)rectangle2D2.getX();
        float f2 = (float)rectangle2D2.getY();
        float f3 = (float)rectangle2D2.getWidth();
        float f4 = (float)rectangle2D2.getHeight();
        AffineTransform affineTransform = SVGUtilities.getPreserveAspectRatioTransform(sVGElement, f3, f4);
        affineTransform.preConcatenate(AffineTransform.getTranslateInstance(f, f2));
        compositeGraphicsNode.setTransform(affineTransform);
        try {
            affineTransform = affineTransform.createInverse();
            GraphicsNodeRableFactory graphicsNodeRableFactory = bridgeContext.getGraphicsNodeRableFactory();
            GraphicsNodeRable graphicsNodeRable = graphicsNodeRableFactory.createGraphicsNodeRable(graphicsNode, bridgeContext.getGraphicsNodeRenderContext());
            Shape shape = affineTransform.createTransformedShape(new Rectangle2D.Float(f, f2, f3, f4));
            compositeGraphicsNode.setClip(new ClipRable8Bit((Filter)graphicsNodeRable, shape));
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            // empty catch block
        }
        bridgeContext.setViewport(viewport);
        return compositeGraphicsNode;
    }

    protected Rectangle2D getImageBounds(BridgeContext bridgeContext, SVGElement sVGElement) {
        CSSStyleDeclaration cSSStyleDeclaration = CSSUtilities.getComputedStyle(sVGElement);
        DefaultUnitProcessorContext defaultUnitProcessorContext = new DefaultUnitProcessorContext(bridgeContext, cSSStyleDeclaration);
        String string = sVGElement.getAttributeNS(null, "x");
        float f = 0.0f;
        if (string.length() != 0) {
            f = SVGUtilities.svgToUserSpace(sVGElement, "x", string, defaultUnitProcessorContext, (short)2);
        }
        string = sVGElement.getAttributeNS(null, "y");
        float f2 = 0.0f;
        if (string.length() != 0) {
            f2 = SVGUtilities.svgToUserSpace(sVGElement, "y", string, defaultUnitProcessorContext, (short)1);
        }
        if ((string = sVGElement.getAttributeNS(null, "width")).length() == 0) {
            throw new MissingAttributeException(Messages.formatMessage("image.width.required", null));
        }
        float f3 = SVGUtilities.svgToUserSpace(sVGElement, "width", string, defaultUnitProcessorContext, (short)2);
        if (f3 < 0.0f) {
            throw new IllegalAttributeValueException(Messages.formatMessage("image.width.negative", null));
        }
        string = sVGElement.getAttributeNS(null, "height");
        if (string.length() == 0) {
            throw new MissingAttributeException(Messages.formatMessage("image.height.required", null));
        }
        float f4 = SVGUtilities.svgToUserSpace(sVGElement, "height", string, defaultUnitProcessorContext, (short)1);
        if (f4 < 0.0f) {
            throw new IllegalAttributeValueException(Messages.formatMessage("image.height.negative", null));
        }
        return new Rectangle2D.Float(f, f2, f3, f4);
    }

    public void update(BridgeMutationEvent bridgeMutationEvent) {
    }

    public boolean isContainer() {
        return false;
    }
}

