/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import java.awt.Paint;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.CSSUtilities;
import org.apache.batik.bridge.DefaultUnitProcessorContext;
import org.apache.batik.bridge.DocumentLoader;
import org.apache.batik.bridge.GVTBuilder;
import org.apache.batik.bridge.IllegalAttributeValueException;
import org.apache.batik.bridge.PaintBridge;
import org.apache.batik.bridge.SVGUtilities;
import org.apache.batik.bridge.URIResolver;
import org.apache.batik.bridge.resources.Messages;
import org.apache.batik.dom.svg.SVGOMDocument;
import org.apache.batik.dom.util.XLinkSupport;
import org.apache.batik.ext.awt.image.renderable.ClipRable8Bit;
import org.apache.batik.ext.awt.image.renderable.ColorMatrixRable;
import org.apache.batik.ext.awt.image.renderable.ColorMatrixRable8Bit;
import org.apache.batik.ext.awt.image.renderable.Filter;
import org.apache.batik.gvt.AbstractGraphicsNode;
import org.apache.batik.gvt.CompositeGraphicsNode;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.gvt.GraphicsNodeRenderContext;
import org.apache.batik.gvt.PatternPaint;
import org.apache.batik.gvt.filter.GraphicsNodeRable;
import org.apache.batik.gvt.filter.GraphicsNodeRableFactory;
import org.apache.batik.util.SVGConstants;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.css.CSSPrimitiveValue;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.svg.SVGDocument;
import org.w3c.dom.svg.SVGElement;

public class SVGPatternElementBridge
implements PaintBridge,
SVGConstants {
    public Paint createStrokePaint(BridgeContext bridgeContext, GraphicsNode graphicsNode, Element element, Element element2) {
        return this.createPaint(bridgeContext, graphicsNode, element, element2, "stroke-opacity");
    }

    public Paint createFillPaint(BridgeContext bridgeContext, GraphicsNode graphicsNode, Element element, Element element2) {
        return this.createPaint(bridgeContext, graphicsNode, element, element2, "fill-opacity");
    }

    protected static List extractPatternChildren(Element element, BridgeContext bridgeContext) {
        GVTBuilder gVTBuilder = bridgeContext.getGVTBuilder();
        Element element2 = element;
        LinkedList<URL> linkedList = new LinkedList<URL>();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        DocumentLoader documentLoader = bridgeContext.getDocumentLoader();
        while (true) {
            Object object;
            Object object2;
            Node node = element2.getFirstChild();
            while (node != null) {
                if (node.getNodeType() == 1 && (object2 = gVTBuilder.build(bridgeContext, (Element)(object = (Element)node))) != null) {
                    arrayList.add(object2);
                }
                node = node.getNextSibling();
            }
            if (arrayList.size() > 0) {
                return arrayList;
            }
            object = XLinkSupport.getXLinkHref(element2);
            if (((String)object).length() == 0) {
                return arrayList;
            }
            object2 = (SVGDocument)element2.getOwnerDocument();
            URL uRL = ((SVGOMDocument)object2).getURLObject();
            try {
                Object object3;
                URL uRL2 = new URL(uRL, (String)object);
                Iterator iterator = linkedList.iterator();
                while (iterator.hasNext()) {
                    object3 = (URL)iterator.next();
                    if (!((URL)object3).sameFile(uRL2) || !((URL)object3).getRef().equals(uRL2.getRef())) continue;
                    throw new IllegalAttributeValueException("circular reference on " + element2);
                }
                object3 = new URIResolver((SVGDocument)object2, documentLoader);
                element2 = ((URIResolver)object3).getElement(uRL2.toString());
                linkedList.add(uRL2);
            }
            catch (MalformedURLException malformedURLException) {
                throw new IllegalAttributeValueException("bad url on " + (String)object);
            }
            catch (IOException iOException) {
                throw new IllegalAttributeValueException("I/O error on " + (String)object);
            }
        }
    }

    protected Paint createPaint(BridgeContext bridgeContext, GraphicsNode graphicsNode, Element element, Element element2, String string) {
        Object object;
        float f;
        Object object2;
        Object object3;
        Cloneable cloneable;
        Object object4;
        GraphicsNodeRenderContext graphicsNodeRenderContext = bridgeContext.getGraphicsNodeRenderContext();
        DocumentLoader documentLoader = bridgeContext.getDocumentLoader();
        String string2 = SVGUtilities.getChainableAttributeNS(element2, null, "patternContentUnits", documentLoader);
        if (string2.length() == 0) {
            string2 = "userSpaceOnUse";
        }
        try {
            int n = SVGUtilities.parseCoordinateSystem(string2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IllegalAttributeValueException(Messages.formatMessage("pattern.units.invalid", new Object[]{string2, "patternContentUnits"}));
        }
        List list = SVGPatternElementBridge.extractPatternChildren(element2, bridgeContext);
        if (list.size() == 0) {
            return null;
        }
        Object object5 = new CompositeGraphicsNode();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ((CompositeGraphicsNode)object5).getChildren().add((GraphicsNode)iterator.next());
        }
        String string3 = SVGUtilities.getChainableAttributeNS(element2, null, "patternTransform", documentLoader);
        AffineTransform affineTransform = string3.length() > 0 ? SVGUtilities.convertAffineTransform(string3) : new AffineTransform();
        CSSStyleDeclaration cSSStyleDeclaration = CSSUtilities.getComputedStyle(element2);
        boolean bl = CSSUtilities.convertOverflow(element2);
        CSSStyleDeclaration cSSStyleDeclaration2 = CSSUtilities.getComputedStyle(element);
        DefaultUnitProcessorContext defaultUnitProcessorContext = new DefaultUnitProcessorContext(bridgeContext, cSSStyleDeclaration);
        Rectangle2D rectangle2D = SVGUtilities.convertPatternRegion(element2, element, graphicsNode, graphicsNodeRenderContext, defaultUnitProcessorContext, documentLoader);
        boolean bl2 = false;
        AffineTransform affineTransform2 = null;
        String string4 = SVGUtilities.getChainableAttributeNS(element2, null, "viewBox", documentLoader);
        Rectangle2D.Float float_ = null;
        if (string4.length() > 0) {
            affineTransform2 = SVGUtilities.getPreserveAspectRatioTransform((SVGElement)element2, (float)rectangle2D.getWidth(), (float)rectangle2D.getHeight());
            object4 = SVGUtilities.parseViewBoxAttribute(string4);
            float_ = new Rectangle2D.Float(object4[0], object4[1], (float)object4[2], (float)object4[3]);
            bl2 = true;
        }
        object4 = null;
        if (!bl2 && "objectBoundingBox".equals(string2)) {
            cloneable = graphicsNode.getGeometryBounds(graphicsNodeRenderContext);
            object4 = new AffineTransform();
            ((AffineTransform)object4).translate(((RectangularShape)cloneable).getX(), ((RectangularShape)cloneable).getY());
            ((AffineTransform)object4).scale(((RectangularShape)cloneable).getWidth(), ((RectangularShape)cloneable).getHeight());
        }
        cloneable = null;
        if (bl2) {
            cloneable = affineTransform2;
            if (bl) {
                object3 = new CompositeGraphicsNode();
                ((CompositeGraphicsNode)object3).getChildren().add(object5);
                object2 = bridgeContext.getGraphicsNodeRableFactory();
                GraphicsNodeRable graphicsNodeRable = object2.createGraphicsNodeRable((GraphicsNode)object3, graphicsNodeRenderContext);
                ((AbstractGraphicsNode)object3).setClip(new ClipRable8Bit((Filter)graphicsNodeRable, float_));
                object5 = object3;
            }
        } else {
            cloneable = object4;
        }
        if ((f = CSSUtilities.convertOpacity((CSSPrimitiveValue)(object2 = (CSSPrimitiveValue)(object3 = CSSUtilities.getComputedStyle(element)).getPropertyCSSValue(string)))) != 1.0f) {
            object = new float[][]{{1.0f, 0.0f, 0.0f, 0.0f, 0.0f}, {0.0f, 1.0f, 0.0f, 0.0f, 0.0f}, {0.0f, 0.0f, 1.0f, 0.0f, 0.0f}, {0.0f, 0.0f, 0.0f, f, 0.0f}};
            ColorMatrixRable colorMatrixRable = ColorMatrixRable8Bit.buildMatrix((float[][])object);
            CompositeGraphicsNode compositeGraphicsNode = new CompositeGraphicsNode();
            compositeGraphicsNode.getChildren().add(object5);
            GraphicsNodeRableFactory graphicsNodeRableFactory = bridgeContext.getGraphicsNodeRableFactory();
            GraphicsNodeRable graphicsNodeRable = graphicsNodeRableFactory.createGraphicsNodeRable((GraphicsNode)object5, graphicsNodeRenderContext);
            colorMatrixRable.setSource(graphicsNodeRable);
            ((AbstractGraphicsNode)object5).setFilter(colorMatrixRable);
            object5 = compositeGraphicsNode;
        }
        object = new PatternPaint((GraphicsNode)object5, graphicsNodeRenderContext, (AffineTransform)cloneable, rectangle2D, !bl, affineTransform);
        return object;
    }
}

