/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.css.svg;

import org.apache.batik.css.CSSDOMExceptionFactory;
import org.apache.batik.css.CSSOMValue;
import org.apache.batik.css.value.AbstractValueFactory;
import org.apache.batik.css.value.ImmutableFloat;
import org.apache.batik.css.value.ImmutableValue;
import org.apache.batik.css.value.ImmutableValueList;
import org.apache.batik.css.value.ValueConstants;
import org.apache.batik.css.value.ValueFactory;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.css.sac.Parser;
import org.w3c.dom.DOMException;

public class StrokeDasharrayFactory
extends AbstractValueFactory {
    protected final ValueFactory NUMBER_FACTORY = new NumberFactory(this.getParser());

    public StrokeDasharrayFactory(Parser parser) {
        super(parser);
    }

    public String getPropertyName() {
        return "stroke-dasharray";
    }

    public ImmutableValue createValue(LexicalUnit lexicalUnit) throws DOMException {
        short s = lexicalUnit.getLexicalUnitType();
        switch (s) {
            case 12: {
                return ValueConstants.INHERIT;
            }
            case 35: {
                return this.createStringValue((short)21, "none");
            }
        }
        return this.createValueList(lexicalUnit);
    }

    public ImmutableValue createStringValue(short s, String string) throws DOMException {
        if (s != 21 || !string.equalsIgnoreCase("none")) {
            throw CSSDOMExceptionFactory.createDOMException((short)15, "invalid.identifier", new Object[]{string});
        }
        return ValueConstants.NONE_VALUE;
    }

    protected ImmutableValue createValueList(LexicalUnit lexicalUnit) throws DOMException {
        ImmutableValueList immutableValueList = new ImmutableValueList(' ');
        do {
            immutableValueList.append(new CSSOMValue(this.NUMBER_FACTORY, this.NUMBER_FACTORY.createValue(lexicalUnit)));
            lexicalUnit = lexicalUnit.getNextLexicalUnit();
            if (lexicalUnit == null) break;
            if (lexicalUnit.getLexicalUnitType() == 0) continue;
            throw CSSDOMExceptionFactory.createDOMException((short)15, "bad.unit.type", new Object[]{new Integer(lexicalUnit.getLexicalUnitType())});
        } while ((lexicalUnit = lexicalUnit.getNextLexicalUnit()) != null);
        return immutableValueList;
    }

    protected static class NumberFactory
    extends AbstractValueFactory {
        public NumberFactory(Parser parser) {
            super(parser);
        }

        public String getPropertyName() {
            return null;
        }

        public ImmutableValue createValue(LexicalUnit lexicalUnit) throws DOMException {
            switch (lexicalUnit.getLexicalUnitType()) {
                case 13: {
                    return new ImmutableFloat(1, lexicalUnit.getIntegerValue());
                }
                case 14: {
                    return new ImmutableFloat(1, lexicalUnit.getFloatValue());
                }
            }
            throw CSSDOMExceptionFactory.createDOMException((short)15, "invalid.lexical.unit", new Object[]{new Integer(lexicalUnit.getLexicalUnitType())});
        }

        public ImmutableValue createFloatValue(short s, float f) throws DOMException {
            switch (s) {
                case 1: {
                    return new ImmutableFloat(1, f);
                }
            }
            throw CSSDOMExceptionFactory.createDOMException((short)15, "invalid.unit.type", new Object[]{new Integer(s)});
        }
    }
}

