/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.dom.events;

import org.apache.batik.dom.events.AbstractEvent;
import org.apache.batik.dom.events.DOMMouseEvent;
import org.apache.batik.dom.events.DOMMutationEvent;
import org.apache.batik.dom.events.DOMUIEvent;
import org.apache.batik.dom.events.EventListenerList;
import org.apache.batik.dom.events.NodeEventTarget;
import org.apache.batik.dom.util.HashTable;
import org.w3c.dom.DOMException;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventException;
import org.w3c.dom.events.EventListener;

public class EventSupport {
    public static final String MUTATION_EVENT_TYPE = "MutationEvents";
    public static final String MOUSE_EVENT_TYPE = "MouseEvents";
    public static final String UI_EVENT_TYPE = "UIEvents";
    protected static HashTable eventFactories = new HashTable();
    protected HashTable capturingListeners;
    protected HashTable bubblingListeners;

    public EventSupport() {
        eventFactories.put(MUTATION_EVENT_TYPE, new MutationEventFactory());
        eventFactories.put(MOUSE_EVENT_TYPE, new MouseEventFactory());
        eventFactories.put(UI_EVENT_TYPE, new UIEventFactory());
    }

    public static Event createEvent(String string) throws DOMException {
        EventFactory eventFactory = (EventFactory)eventFactories.get(string);
        if (eventFactory == null) {
            throw new DOMException(9, "Bad event type: " + string);
        }
        return eventFactory.createEvent();
    }

    public static void registerEventFactory(String string, EventFactory eventFactory) {
        eventFactories.put(string, eventFactory);
    }

    public void addEventListener(String string, EventListener eventListener, boolean bl) {
        HashTable hashTable;
        if (bl) {
            if (this.capturingListeners == null) {
                this.capturingListeners = new HashTable();
            }
            hashTable = this.capturingListeners;
        } else {
            if (this.bubblingListeners == null) {
                this.bubblingListeners = new HashTable();
            }
            hashTable = this.bubblingListeners;
        }
        EventListenerList eventListenerList = (EventListenerList)hashTable.get(string);
        if (eventListenerList == null) {
            eventListenerList = new EventListenerList();
            hashTable.put(string, eventListenerList);
        }
        if (!eventListenerList.contains(eventListener)) {
            eventListenerList.add(eventListener);
        }
    }

    public void removeEventListener(String string, EventListener eventListener, boolean bl) {
        HashTable hashTable = bl ? this.capturingListeners : this.bubblingListeners;
        if (hashTable == null) {
            return;
        }
        EventListenerList eventListenerList = (EventListenerList)hashTable.get(string);
        if (eventListenerList != null) {
            eventListenerList.remove(eventListener);
        }
    }

    public static boolean dispatchEvent(NodeEventTarget nodeEventTarget, Event event) throws EventException {
        AbstractEvent abstractEvent = (AbstractEvent)event;
        if (abstractEvent == null) {
            return false;
        }
        String string = abstractEvent.getType();
        if (string == null) {
            throw EventSupport.createUnspecifiedEventTypeErr("Event type can't be null");
        }
        abstractEvent.setTarget(nodeEventTarget);
        abstractEvent.stopPropagation(false);
        abstractEvent.preventDefault(false);
        NodeEventTarget[] nodeEventTargetArray = EventSupport.getAncestors(nodeEventTarget);
        abstractEvent.setEventPhase((short)1);
        int n = 0;
        while (n < nodeEventTargetArray.length && !abstractEvent.getStopPropagation()) {
            NodeEventTarget nodeEventTarget2 = nodeEventTargetArray[n];
            abstractEvent.setCurrentTarget(nodeEventTarget2);
            EventSupport.fireEventListeners(nodeEventTarget2, abstractEvent, true);
            ++n;
        }
        if (!abstractEvent.getStopPropagation()) {
            abstractEvent.setEventPhase((short)2);
            abstractEvent.setCurrentTarget(nodeEventTarget);
            EventSupport.fireEventListeners(nodeEventTarget, abstractEvent, false);
        }
        if (abstractEvent.getBubbles()) {
            abstractEvent.setEventPhase((short)3);
            int n2 = nodeEventTargetArray.length - 1;
            while (n2 >= 0 && !abstractEvent.getStopPropagation()) {
                NodeEventTarget nodeEventTarget3 = nodeEventTargetArray[n2];
                abstractEvent.setCurrentTarget(nodeEventTarget3);
                EventSupport.fireEventListeners(nodeEventTarget3, abstractEvent, false);
                --n2;
            }
        }
        return abstractEvent.getPreventDefault();
    }

    private static void fireEventListeners(NodeEventTarget nodeEventTarget, Event event, boolean bl) {
        String string = event.getType();
        EventSupport eventSupport = nodeEventTarget.getEventSupport();
        if (eventSupport == null) {
            return;
        }
        EventListenerList eventListenerList = eventSupport.getEventListeners(string, bl);
        if (eventListenerList == null) {
            return;
        }
        EventListener[] eventListenerArray = eventListenerList.getEventListeners();
        if (eventListenerArray == null) {
            return;
        }
        int n = 0;
        while (n < eventListenerArray.length) {
            try {
                eventListenerArray[n].handleEvent(event);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            ++n;
        }
    }

    private static NodeEventTarget[] getAncestors(NodeEventTarget nodeEventTarget) {
        nodeEventTarget = nodeEventTarget.getParentNodeEventTarget();
        int n = 0;
        NodeEventTarget nodeEventTarget2 = nodeEventTarget;
        while (nodeEventTarget2 != null) {
            nodeEventTarget2 = nodeEventTarget2.getParentNodeEventTarget();
            ++n;
        }
        NodeEventTarget[] nodeEventTargetArray = new NodeEventTarget[n];
        int n2 = n - 1;
        while (n2 >= 0) {
            nodeEventTargetArray[n2] = nodeEventTarget;
            --n2;
            nodeEventTarget = nodeEventTarget.getParentNodeEventTarget();
        }
        return nodeEventTargetArray;
    }

    public EventListenerList getEventListeners(String string, boolean bl) {
        HashTable hashTable;
        HashTable hashTable2 = hashTable = bl ? this.capturingListeners : this.bubblingListeners;
        if (hashTable == null) {
            return null;
        }
        return (EventListenerList)hashTable.get(string);
    }

    private static EventException createEventException(short s, String string) {
        return new EventException(s, string);
    }

    private static EventException createUnspecifiedEventTypeErr(String string) {
        return EventSupport.createEventException((short)0, string);
    }

    protected static class UIEventFactory
    implements EventFactory {
        protected UIEventFactory() {
        }

        public Event createEvent() {
            return new DOMUIEvent();
        }
    }

    protected static class MouseEventFactory
    implements EventFactory {
        protected MouseEventFactory() {
        }

        public Event createEvent() {
            return new DOMMouseEvent();
        }
    }

    protected static class MutationEventFactory
    implements EventFactory {
        protected MutationEventFactory() {
        }

        public Event createEvent() {
            return new DOMMutationEvent();
        }
    }

    public static interface EventFactory {
        public Event createEvent();
    }
}

