/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.script;

import java.util.HashMap;
import java.util.WeakHashMap;
import org.apache.batik.script.DocumentProxy;
import org.apache.batik.script.Interpreter;
import org.apache.batik.script.InterpreterFactory;
import org.apache.batik.script.SVGDocumentProxy;
import org.w3c.dom.Document;
import org.w3c.dom.svg.SVGDocument;

public class InterpreterPool {
    private HashMap factories = new HashMap(3);
    private WeakHashMap documentsMap = new WeakHashMap(1);
    private static final String RHINO = "org.apache.batik.script.rhino.RhinoInterpreterFactory";
    private static final String JPYTHON = "org.apache.batik.script.jpython.JPythonInterpreterFactory";
    private static final String JACL = "org.apache.batik.script.jacl.JaclInterpreterFactory";
    private static HashMap defaultFactories = null;

    public InterpreterPool() {
        InterpreterPool.initDefaultFactories();
        this.factories.putAll(defaultFactories);
    }

    private static void initDefaultFactories() {
        if (defaultFactories == null) {
            defaultFactories = new HashMap(3);
            InterpreterFactory interpreterFactory = null;
            try {
                interpreterFactory = (InterpreterFactory)Class.forName(RHINO).newInstance();
                defaultFactories.put("text/ecmascript", interpreterFactory);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                interpreterFactory = (InterpreterFactory)Class.forName(JPYTHON).newInstance();
                defaultFactories.put("text/python", interpreterFactory);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                interpreterFactory = (InterpreterFactory)Class.forName(JACL).newInstance();
                defaultFactories.put("text/tcl", interpreterFactory);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private static Document createDocumentProxy(Document document) {
        if (document instanceof SVGDocument) {
            return new SVGDocumentProxy((SVGDocument)document);
        }
        return new DocumentProxy(document);
    }

    public synchronized Interpreter getInterpreter(Document document, String string) {
        InterpreterFactory interpreterFactory;
        Interpreter interpreter;
        HashMap<String, Interpreter> hashMap = (HashMap<String, Interpreter>)this.documentsMap.get(document);
        if (hashMap == null) {
            hashMap = new HashMap<String, Interpreter>(1);
            this.documentsMap.put(document, hashMap);
        }
        if ((interpreter = (Interpreter)hashMap.get(string)) == null && (interpreterFactory = (InterpreterFactory)this.factories.get(string)) != null) {
            try {
                interpreter = interpreterFactory.createInterpreter();
                if (document != null) {
                    interpreter.bindObject("document", InterpreterPool.createDocumentProxy(document));
                }
                hashMap.put(string, interpreter);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return interpreter;
    }

    public void putInterpreterFactory(String string, InterpreterFactory interpreterFactory) {
        this.factories.put(string, interpreterFactory);
    }

    public void removeInterpreterFactory(String string) {
        this.factories.remove(string);
    }
}

