/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.runtime.log;

import java.io.File;
import org.apache.log.Category;
import org.apache.log.LogKit;
import org.apache.log.LogTarget;
import org.apache.log.Logger;
import org.apache.log.output.FileOutputLogTarget;
import org.apache.velocity.runtime.Runtime;
import org.apache.velocity.runtime.log.LogSystem;
import org.apache.velocity.runtime.log.VelocityFormatter;

public class AvalonLogSystem
implements LogSystem {
    private Logger logger = null;
    private String logPath = "";

    public AvalonLogSystem() {
        String logfile = (String)Runtime.getProperty("runtime.log");
        try {
            this.init(logfile);
            this.logVelocityMessage(0, "AvalonLogSystem initialized using logfile " + this.logPath);
        }
        catch (Exception e) {
            System.out.println("PANIC : Error configuring AvalonLogSystem : " + e);
            System.err.println("PANIC : Error configuring AvalonLogSystem : " + e);
        }
    }

    public void init(String logFile) throws Exception {
        String targetName = "velocity";
        String priority = "DEBUG";
        Category category = LogKit.createCategory(targetName, LogKit.getPriorityForName(priority));
        FileOutputLogTarget target = new FileOutputLogTarget();
        File logFileLocation = new File(logFile);
        this.logPath = logFileLocation.getAbsolutePath();
        target.setFilename(this.logPath);
        target.setFormatter(new VelocityFormatter());
        target.setFormat("%{time} %{message}\\n%{throwable}");
        LogTarget[] logTargets = null;
        if (null != target) {
            logTargets = new LogTarget[]{target};
        }
        this.logger = LogKit.createLogger(category, logTargets);
    }

    public void logVelocityMessage(int level, String message) {
        switch (level) {
            case 2: {
                this.logger.warn(message);
                break;
            }
            case 1: {
                this.logger.info(message);
                break;
            }
            case 0: {
                this.logger.debug(message);
                break;
            }
            case 3: {
                this.logger.error(message);
                break;
            }
            default: {
                this.logger.info(message);
            }
        }
    }
}

