/*
 * Decompiled with CFR 0.152.
 */
package org.apache.excalibur.pool;

import org.apache.avalon.Initializable;
import org.apache.avalon.Poolable;
import org.apache.avalon.Recyclable;
import org.apache.avalon.SingleThreaded;
import org.apache.excalibur.pool.ObjectFactory;
import org.apache.excalibur.pool.Pool;
import org.apache.excalibur.pool.PoolController;
import org.apache.excalibur.pool.Resizable;

public class SingleThreadedPool
implements Pool,
SingleThreaded,
Resizable {
    protected int m_count = 0;
    protected Poolable[] m_pool;
    protected ObjectFactory m_factory;
    protected PoolController m_controller;
    protected int m_maximum;
    protected int m_initial;

    public void init() throws Exception {
        this.grow(this.m_maximum);
        this.fill(this.m_initial);
    }

    public Poolable get() throws Exception {
        int n;
        if (this.m_pool == null && this.m_controller != null && (n = this.m_controller.grow()) > 0) {
            this.grow(n);
        }
        if (this.m_count == 0) {
            return (Poolable)this.m_factory.newInstance();
        }
        --this.m_count;
        Poolable poolable = this.m_pool[this.m_count];
        this.m_pool[this.m_count] = null;
        return poolable;
    }

    public void put(Poolable poolable) {
        int n;
        if (poolable instanceof Recyclable) {
            ((Recyclable)poolable).recycle();
        }
        if (this.m_pool.length == this.m_count + 1 && this.m_controller != null && (n = this.m_controller.shrink()) > 0) {
            this.shrink(n);
        }
        if (this.m_pool.length > this.m_count + 1) {
            this.m_pool[this.m_count++] = poolable;
        }
    }

    public final int getCapacity() {
        return this.m_pool.length;
    }

    public final int getSize() {
        return this.m_count;
    }

    public final void fill(int n) throws Exception {
        int n2 = Math.min(this.m_pool.length, n);
        int n3 = this.m_count;
        while (n3 < n2) {
            this.m_pool[n3] = (Poolable)this.m_factory.newInstance();
            ++n3;
        }
        this.m_count = n2;
    }

    public final void grow(int n) {
        if (this.m_pool == null) {
            this.m_pool = new Poolable[n];
            return;
        }
        Poolable[] poolableArray = new Poolable[n + this.m_pool.length];
        System.arraycopy(this.m_pool, 0, poolableArray, 0, this.m_pool.length);
        this.m_pool = poolableArray;
    }

    public final void shrink(int n) {
        Poolable[] poolableArray = new Poolable[this.m_pool.length - n];
        System.arraycopy(this.m_pool, 0, poolableArray, 0, poolableArray.length);
        this.m_pool = poolableArray;
    }

    public SingleThreadedPool(ObjectFactory objectFactory, PoolController poolController, int n, int n2) throws Exception {
        this.m_factory = objectFactory;
        this.m_controller = poolController;
        this.m_maximum = n2;
        this.m_initial = n;
        if (!(this instanceof Initializable)) {
            this.init();
        }
    }
}

