
import java.sql.*;


/**
 * test fetching empty results sets
 *
 */
public class t0013
{
   static public void main(String args[])
      throws SQLException, java.lang.ClassNotFoundException 
   {
      System.out.println("test fetching empty results sets");

      // open the database
      Class.forName("com.internetcds.jdbc.tds.Driver");

      int         count    = 0;
      Connection  cx       = Common.getConnection();
      Statement   stmt     = cx.createStatement();
      boolean     passed   = true;

      try
      {
         stmt.executeUpdate("drop table t0013");
      }
      catch (SQLException e)
      {
         if (! (e.getMessage().startsWith("Cannot drop the table 't0013', because it does")))
         {
            throw e;
         }
      }
    
      count = stmt.executeUpdate("create table t0013              "
                                 + "  (mytime  datetime not null, "
                                 + "   mytime2 datetime null     )");
      System.out.println("Creating table affected " + count + " rows");
    
      PreparedStatement  pStmt;

      pStmt = cx.prepareStatement(
         "select mytime, mytime2 from t0013");
    
      ResultSet  rs1 = stmt.executeQuery("select mytime,  mytime2"
                                         + " from t0013");
      ResultSet  rs2 = pStmt.executeQuery();
    
      passed = passed && (!rs1.next());
      passed = passed && (!rs2.next());

      System.out.println("\n" + (passed ? "Passed" : "Failed") 
                         + " t0013.\n");
      System.exit(passed ? 0 : 1);
   }
}

