/*
 * BackupStatus.java
 *
 * Created on December 13, 2000, 6:52 AM
 */

package com.sun.enterprise.config.backup;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import com.sun.enterprise.config.backup.status.StatusConstants;
import com.sun.enterprise.config.backup.status.Status;
import com.sun.enterprise.config.backup.utils.LoggerHelper;

/**
 *
 * @author  sridatta
 */
public class HistoryEntry implements Serializable, 
                                StatusConstants,
                                EnvironmentConstants,
                                DefaultConstants {
       
    private String _operation = OPERATION_TYPE_UNKNOWN;
    private long _timestamp=-1;
    private Status _status;
    private String _tmpStringValue;
    
   //private ArrayList _historyEntries;
    /** Creates a new instance of BackupStatus */
    public HistoryEntry() {
    }
    
    public HistoryEntry(String line) throws BackupException {
        this();
        if(line == null || line == "") {
                return;
        }
            
       /* try {   
            String[] parts = line.split(HISTORY_FILE_INITIAL_SEPARATOR);
            String[] vars = parts[1].split(HISTORY_FILE_DATA_SEPARATOR);
            initVariables(vars);
        } catch(Exception e) {
            //incase of exception
            //log it and ignore
            
            LoggerHelper.warning("error_creating_history_entry");
            LoggerHelper.warning("The file could be bad. Move it out");
            LoggerHelper.fine("Actual Exception is", e);
        }
        */
        _tmpStringValue = line;
    }
    
    public HistoryEntry(Status status) {
        if(status!= null) {
            _operation = status.getOperation();
            _timestamp = status.getCreationTimeStamp();
            _status = status;
            _tmpStringValue = status.toString();
        }
    }
    /**
     * careful about order of variables
     */
    private void initVariables(String[] vars) {
        _operation = vars[0];
        _timestamp = new Long(vars[1]).longValue();
        
        //TBD FIXME
        //initialize status
    }
    
    public String toString() {
        if(_tmpStringValue == null) {
            return getDate() + HISTORY_FILE_INITIAL_SEPARATOR + 
                    _operation + HISTORY_FILE_DATA_SEPARATOR + 
                    _timestamp + HISTORY_FILE_DATA_SEPARATOR +
                    HISTORY_FILE_EXTRA_DATA_SEPARATOR_START + 
                    getStatusAsString() + 
                    HISTORY_FILE_EXTRA_DATA_SEPARATOR_END;
        } else {
            return _tmpStringValue;
        }
    }
    private String getDate() {
        return new Date(_timestamp).toString();
    }
    private String getStatusAsString() {
       if(_status == null) {
            return "No Extra Details";
        }
        return _status.toString();
    }
}
