/*
 * StatusCode.java
 *
 * Created on December 13, 2000, 6:32 AM
 */

package com.sun.enterprise.config.backup.status;

import com.sun.enterprise.config.backup.BackupException;
import com.sun.enterprise.config.backup.utils.LocalStringsHelper;

//import i18n UTIL
//TBD FIXME

/**
 *
 * @author  sridatta
 */
public class ExecutionType implements StatusConstants {
    private String _type;
    
    /** Creates a new instance of StatusCode */
    public ExecutionType() {
        _type = TYPE_UNKNOWN;
    }
    
    public String getExecutionType() {
        return _type;
    }
    
    void setExecutionType(String type) throws BackupException {
        if(type != TYPE_OFFLINE && 
                    type != TYPE_ONLINE) {
            throw new BackupException
                ("config_backup_wrong_execution_type", LocalStringsHelper.getString
                    ("config_backup_wrong_execution_type", type));
        }
        _type = type;
    }
    
    public boolean isOnline() {
        return (_type == TYPE_ONLINE);
    }
    
    public String toString() {
        return _type;
    }
}