/*
 * BackupUI.java
 *
 * Created on January 15, 2004, 10:48 PM
 */

package com.sun.enterprise.config.backup.ui;
import java.io.*;
import com.sun.enterprise.util.Console;
import com.sun.enterprise.config.backup.status.StatusConstants;
import com.sun.enterprise.config.backup.BackupRequest;
import com.sun.enterprise.config.backup.appserver.BackupManager;
/**
 *
 * @author  bnevins
 */
public class BackupUI
{
	public BackupUI()
	{
	}
 
	public static void main(String[] args)
	{
		String s;
		String userInfo = "qberry";
		String execType = StatusConstants.STORAGE_TYPE_ZIP;
		//String execType = StatusConstants.STORAGE_TYPE_DIRECTORY;
		String fromDir	= "C:/temp/domains/domain1/applications,C:/temp/domains/domain1/config,C:/temp/domains/domain1/generated";
		//String fromDir	= "C:/tmp/domains/domain1/applications,C:/tmp/domains/domain1/generated,C:/tmp/domains/domain1/config";
		//String fromDir	= "C:/tmp/domains/domain1/applications";
		String toDir	= "c:/temp/backuprestore";
		String command	= "backup";
		boolean ask = false;
		
		new File(toDir).mkdirs();
		
		if(ask)
		{
			s = Console.readLine("User Info [" + userInfo + "]");

			if(s.length() > 0)
				userInfo = s;

			if(userInfo.length() < 1)
				userInfo = null;

			s = Console.readLine("Backup Storage Type D|Z  [" + execType + "]").toLowerCase();

			if(s != null && s.length() > 0)
			{
				if(s.charAt(0) == 'z')
					execType = StatusConstants.STORAGE_TYPE_ZIP;
				else
					execType = StatusConstants.STORAGE_TYPE_DIRECTORY;
			}

			s = Console.readLine("Directory to backup: [" + fromDir + "]");

			if(s.length() > 0)
				fromDir = s;

			s = Console.readLine("Directory to store backup files: [" + toDir + "]");

			if(s.length() > 0)
				toDir = s;


			s = Console.readLine("Command: [" + command + "]");

			if(s.length() > 0)
				command = s;
		}
		BackupRequest request = new BackupRequest();
		
		request.setDirToStoreBackupFiles(toDir);
		request.setDirsToBackup(new String[]  { fromDir });
		request.setBackupStorageType(execType);
		request.setCommand(command);
		request.setUserInfo(userInfo);
		request.verify();
		BackupManager mgr = new BackupManager();

		mgr.execute(request);
	}
}