/*  tilp - link program for TI calculators
 *  Copyright (C) 1999-2001  Romain Lievin
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef STRUCT_H
#define STRUCT_H

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif

#include <glib.h>

#define MAXCHARS 256

/*
  Portable installation paths
*/
struct InstPaths_
{
  gchar *base_dir;		// Windows directory (determined at startup)
  
  gchar *share_dir;		// shared directory
  gchar *locale_dir;		// locale
  gchar *manpage_dir;		// manpages
  gchar *help_dir;		// help files
  gchar *pixmap_dir;		// pixmaps
  gchar *rom_dir;		// ROMs directory
  gchar *skin_dir;		// Skins directory

  gchar current_dir[1024];	// current working directory
} inst_paths;
typedef struct InstPaths_ InstPaths;

extern InstPaths inst_paths;

/*
  General GtkTiEmu options
*/
struct options_
{
  // Point on glob_info structure fields (so that fields are shared)
  int *gray_planes;
  unsigned long *tick_rate;
  unsigned long *cycle_rate;
  int *i_tick;
  unsigned long *dark_color;
  unsigned long *light_color;
  int *sync_one;
  int *background;
  
  struct ticable_param *lp;

  // GtkTiEMu fields
  char *rom_file;
  char *ram_file;
  char *tib_file;

  char locale[MAXCHARS];
  gint code_lines;
  gint stack_lines;
  gint mem_lines;
  gint img_type;
  gint img_format;
  gint img_size;
  gchar *screen_file;
  gint screen_counter;
  gint console;
};
typedef struct options_ Options;

extern Options options;

/* Misc */
struct sel
{
  gint address; // address of the breakpoint
  gint id;      // breakpoint id
};
typedef struct sel CODE_BKPT;

struct data_bkpt
{
  gint address;  // breakpoint address
  gint address2; // second bkpt address for range
  gint mode;     // breakpoint access mode
  gint id;       // breakpoint id
};
typedef struct data_bkpt DATA_BKPT;

#endif
