/*
 * Header file to maintain compatibility among different kernel versions.
 *
 * Copyright (c) 2004-2006  Zhu Yi <yi.zhu@intel.com>, Intel Corporation
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation. See README and COPYING for
 * more details.
 */

#include <linux/version.h>

#if LINUX_VERSION_CODE > KERNEL_VERSION(2,6,15)
# include <linux/mutex.h>
#else
# define mutex semaphore
# define mutex_init init_MUTEX
# define mutex_lock down
# define mutex_unlock up
#endif

#ifndef IW_QUAL_DBM
# define IW_QUAL_DBM 0
#endif

#ifndef ARPHRD_IEEE80211_RADIOTAP
#define ARPHRD_IEEE80211_RADIOTAP 803	/* IEEE 802.11 + radiotap header */
#endif

#ifndef __bitwise		/* if __leXX is not defined */
typedef __u16 __le16;
typedef __u64 __le64;
#endif

#if WIRELESS_EXT < 17
#define IW_QUAL_QUAL_UPDATED    0x01	/* Value was updated since last read */
#define IW_QUAL_LEVEL_UPDATED   0x02
#define IW_QUAL_NOISE_UPDATED   0x04
#define IW_QUAL_ALL_UPDATED     0x07
#define IW_QUAL_QUAL_INVALID    0x10	/* Driver doesn't provide value */
#define IW_QUAL_LEVEL_INVALID   0x20
#define IW_QUAL_NOISE_INVALID   0x40
#define IW_QUAL_ALL_INVALID     0x70
#endif

#if LINUX_VERSION_CODE <= KERNEL_VERSION(2,6,8)
#define	__iomem
#define	__le32		u32
#endif

#ifndef	NETDEV_TX_OK
#define	NETDEV_TX_OK		0
#endif

#ifndef IRQF_SHARED
#define IRQF_SHARED	SA_SHIRQ
#endif

#ifndef IW_SCAN_TYPE_ACTIVE
#define IW_SCAN_TYPE_ACTIVE 0
#define IW_SCAN_TYPE_PASSIVE 1
#endif

#if WIRELESS_EXT < 18
#define IW_AUTH_ALG_OPEN_SYSTEM			0x1
#define IW_AUTH_ALG_SHARED_KEY			0x2
#define IW_AUTH_ALG_LEAP			0x4
#endif

#if LINUX_VERSION_CODE < KERNEL_VERSION(2,6,14)
static inline void *kzalloc(size_t size, unsigned flags)
{
	void *ret = kmalloc(size, flags);
	if (ret)
		memset(ret, 0, size);
	return ret;
}
#endif
