/*
* JBoss, Home of Professional Open Source
* Copyright 2006, JBoss Inc., and individual contributors as indicated
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/
package org.jboss.test.web.test;

//import java.net.HttpURLConnection;
import java.net.URL;
//import javax.management.ObjectName;

import junit.framework.Test;
import junit.framework.TestSuite;

import org.jboss.test.JBossTestCase;
import org.jboss.test.JBossTestSetup;
import org.jboss.test.util.web.HttpUtils;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.methods.GetMethod;

/** Tests of JSF integration into the JBoss server. This test
 requires than a web container and JSF implementation be integrated 
 into the JBoss server. The tests currently do NOT use the 
 java.net.HttpURLConnection and associated http client and these do 
 not return valid HTTP error codes so if a failure occurs it is best 
 to connect the webserver using a browser to look for additional error
 info. 
 
 @author Stan.Silvert@jboss.org
 @version $Revision: 59998 $
 */
public class JSFIntegrationUnitTestCase extends JBossTestCase
{
   private String baseURL = HttpUtils.getBaseURL(); 
   private HttpClient client = new HttpClient();
   
   public JSFIntegrationUnitTestCase(String name)
   {
      super(name);
   }
   
   /** Access the http://localhost/jbosstest-jsf/index.jsf.
    */
   public void testJSFIntegrated() throws Exception
   {
      client.executeMethod(makeRequest());

      HttpMethodBase result = makeRequest();

      // need to hit it twice with the same session for test to pass
      client.executeMethod(result);

      String responseBody = result.getResponseBodyAsString();
      if (responseBody == null) {
         throw new Exception("Unable to get response from server.");
      }

      assertTrue(contains(responseBody, "@PostConstruct was called."));
      assertTrue(contains(responseBody, "@PreDestroy was called."));
      assertTrue(contains(responseBody, "Datasource was injected."));

      // Tests JSF/JSTL integration
      assertTrue(contains(responseBody, "number one"));
      assertTrue(contains(responseBody, "number two"));
      assertTrue(contains(responseBody, "number three"));

      // Tests enum support 
      assertTrue(contains(responseBody, "JBoss Color selection is PURPLE"));
   }   

   private boolean contains(String base, String target) {
      return base.indexOf(target) != -1;
   }

   private GetMethod makeRequest() {
      return new GetMethod(baseURL+"jbosstest-jsf/index.jsf");
   }

   public static Test suite() throws Exception
   {
      TestSuite suite = new TestSuite();
      suite.addTest(new TestSuite(JSFIntegrationUnitTestCase.class));

      // Create an initializer for the test suite
      Test wrapper = new JBossTestSetup(suite)
      {
         protected void setUp() throws Exception
         {
            super.setUp();
            deploy("jbosstest-jsf.war");           
         }
         protected void tearDown() throws Exception
         {
            undeploy("jbosstest-jsf.war");
            super.tearDown();            
         }
      };
      return wrapper;
   }
   

}
