/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.module.oscache.web.filter;

import com.opensymphony.module.oscache.base.Cache;
import com.opensymphony.module.oscache.base.NeedsRefreshException;
import com.opensymphony.module.oscache.web.ServletCacheAdministrator;
import com.opensymphony.module.oscache.web.filter.CacheHttpServletResponseWrapper;
import com.opensymphony.module.oscache.web.filter.ResponseContent;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class CacheFilter
implements Filter {
    private FilterConfig config;
    private int cacheScope = 4;
    private ServletCacheAdministrator admin = null;
    private int time = 3600;

    public void init(FilterConfig filterConfig) {
        this.config = filterConfig;
        this.admin = ServletCacheAdministrator.getInstance(this.config.getServletContext());
        try {
            this.time = Integer.parseInt(this.config.getInitParameter("time"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws ServletException, IOException {
        this.admin.log("<cache>: filter in scope " + this.cacheScope);
        String string = this.admin.generateEntryKey(null, (HttpServletRequest)servletRequest, this.cacheScope);
        Cache cache = this.admin.getCache((HttpServletRequest)servletRequest, this.cacheScope);
        try {
            ResponseContent responseContent = (ResponseContent)cache.getFromCache(string, this.time);
            this.admin.log("<cache>: Using cached entry for " + string);
            responseContent.writeTo(servletResponse);
        }
        catch (NeedsRefreshException needsRefreshException) {
            this.admin.log("<cache>: New cache entry, cache stale or cache scope flushed for " + string);
            CacheHttpServletResponseWrapper cacheHttpServletResponseWrapper = new CacheHttpServletResponseWrapper((HttpServletResponse)servletResponse);
            filterChain.doFilter(servletRequest, (ServletResponse)cacheHttpServletResponseWrapper);
            cache.putInCache(string, cacheHttpServletResponseWrapper.getContent());
        }
    }
}

